/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.concepts;

import java.io.Serializable;
import org.eclipse.jdt.annotation.NonNull;

public record SemVer(int major, int minor, int patch) implements Comparable<SemVer>,
Serializable
{
    private static final long serialVersionUID = 1L;

    public SemVer {
        if (major < 0) {
            throw new IllegalArgumentException("Major version has to be non-negative");
        }
        if (minor < 0) {
            throw new IllegalArgumentException("Minor version has to be non-negative");
        }
        if (patch < 0) {
            throw new IllegalArgumentException("Patch version has to be non-negative");
        }
    }

    public SemVer(int major) {
        this(major, 0);
    }

    public SemVer(int major, int minor) {
        this(major, minor, 0);
    }

    public static @NonNull SemVer valueOf(@NonNull String str) {
        int minorIdx = str.indexOf(46);
        if (minorIdx == -1) {
            return new SemVer(Integer.parseInt(str));
        }
        int patchIdx = str.indexOf(46, minorIdx + 1);
        if (patchIdx == -1) {
            String minorStr = str.substring(minorIdx + 1);
            return new SemVer(Integer.parseInt(str.substring(0, minorIdx), 10), Integer.parseInt(minorStr, 10));
        }
        String minorStr = str.substring(minorIdx + 1, patchIdx);
        return new SemVer(Integer.parseInt(str.substring(0, minorIdx), 10), Integer.parseInt(minorStr, 10), Integer.parseInt(str.substring(patchIdx + 1), 10));
    }

    @Override
    public int compareTo(SemVer other) {
        int cmp = Integer.compare(this.major, other.major);
        if (cmp == 0 && (cmp = Integer.compare(this.minor, other.minor)) == 0) {
            cmp = Integer.compare(this.patch, other.patch);
        }
        return cmp;
    }

    @Override
    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }
}

