/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.concepts;

import com.google.common.base.MoreObjects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.opendaylight.yangtools.concepts.Registration;

public abstract class AbstractRegistration
implements Registration {
    private static final AtomicIntegerFieldUpdater<AbstractRegistration> CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractRegistration.class, "closed");
    private volatile int closed = 0;

    protected abstract void removeRegistration();

    public final boolean isClosed() {
        return this.closed != 0;
    }

    @Override
    public final void close() {
        if (CLOSED_UPDATER.compareAndSet(this, 0, 1)) {
            this.removeRegistration();
        }
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("closed", this.closed);
    }
}

