/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc7952.parser;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationEffectiveStatement;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationStatement;
import org.opendaylight.yangtools.rfc7952.model.api.MetadataStatements;
import org.opendaylight.yangtools.rfc7952.parser.AnnotationEffectiveStatementImpl;
import org.opendaylight.yangtools.rfc7952.parser.AnnotationStatementImpl;
import org.opendaylight.yangtools.rfc7952.parser.RefAnnotationStatement;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class AnnotationStatementSupport
extends AbstractStatementSupport<QName, AnnotationStatement, AnnotationEffectiveStatement> {
    private static final SubstatementValidator VALIDATOR = SubstatementValidator.builder((StatementDefinition)MetadataStatements.ANNOTATION).addMandatory((StatementDefinition)YangStmtMapping.TYPE).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addOptional((StatementDefinition)YangStmtMapping.UNITS).build();

    public AnnotationStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)MetadataStatements.ANNOTATION, StatementSupport.StatementPolicy.reject(), config, VALIDATOR);
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public void onStatementAdded(StmtContext.Mutable<QName, AnnotationStatement, AnnotationEffectiveStatement> stmt) {
        StatementDefinition parentDef = stmt.coerceParentContext().publicDefinition();
        SourceException.throwIf((YangStmtMapping.MODULE != parentDef && YangStmtMapping.SUBMODULE != parentDef ? 1 : 0) != 0, stmt, (String)"Annotations may only be defined at root of either a module or a submodule", (Object[])new Object[0]);
    }

    protected AnnotationStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return new AnnotationStatementImpl((QName)ctx.getArgument(), substatements);
    }

    protected AnnotationStatement attachDeclarationReference(AnnotationStatement stmt, DeclarationReference reference) {
        return new RefAnnotationStatement(stmt, reference);
    }

    protected AnnotationEffectiveStatement createEffective(EffectiveStmtCtx.Current<QName, AnnotationStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new AnnotationEffectiveStatementImpl(stmt, substatements);
    }
}

