/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassLoaderUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ClassLoaderUtils.class);

    private ClassLoaderUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R> R applyWithClassLoader(@NonNull ClassLoader cls, @NonNull Function<T, R> function, T input) {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldCls = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(Objects.requireNonNull(cls));
        try {
            R r = Objects.requireNonNull(function).apply(input);
            return r;
        }
        finally {
            currentThread.setContextClassLoader(oldCls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V callWithClassLoader(@NonNull ClassLoader cls, @NonNull Callable<V> callable) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldCls = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(Objects.requireNonNull(cls));
        try {
            V v = Objects.requireNonNull(callable).call();
            return v;
        }
        finally {
            currentThread.setContextClassLoader(oldCls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V getWithClassLoader(@NonNull ClassLoader cls, @NonNull Supplier<V> supplier) {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldCls = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(Objects.requireNonNull(cls));
        try {
            V v = Objects.requireNonNull(supplier).get();
            return v;
        }
        finally {
            currentThread.setContextClassLoader(oldCls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithClassLoader(@NonNull ClassLoader cls, @NonNull Runnable runnable) {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldCls = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(Objects.requireNonNull(cls));
        try {
            Objects.requireNonNull(runnable).run();
        }
        finally {
            currentThread.setContextClassLoader(oldCls);
        }
    }

    public static <S, G, P> Optional<Class<P>> findFirstGenericArgument(Class<S> scannedClass, Class<G> genericType) {
        return ClassLoaderUtils.findGenericArgument(scannedClass, genericType, 0);
    }

    public static <S, G, P> Optional<Class<P>> findGenericArgument(Class<S> scannedClass, Class<G> genericType, int index) {
        return ClassLoaderUtils.getWithClassLoader(scannedClass.getClassLoader(), () -> ClassLoaderUtils.findParameterizedType(scannedClass, genericType).map(ptype -> (Class)ptype.getActualTypeArguments()[index]));
    }

    public static Optional<ParameterizedType> findParameterizedType(Class<?> subclass, Class<?> genericType) {
        Objects.requireNonNull(genericType);
        for (Type type : subclass.getGenericInterfaces()) {
            ParameterizedType ptype;
            if (!(type instanceof ParameterizedType) || !genericType.equals((ptype = (ParameterizedType)type).getRawType())) continue;
            return Optional.of(ptype);
        }
        LOG.debug("Class {} does not declare interface {}", subclass, genericType);
        return Optional.empty();
    }

    public static Optional<Type> getFirstGenericParameter(Type type) {
        Optional<Type> optional;
        Objects.requireNonNull(type);
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            optional = Optional.of(ptype.getActualTypeArguments()[0]);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }
}

