/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

final class ConstantArrayCollection<E>
implements Collection<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final E @NonNull [] array;

    ConstantArrayCollection(E @NonNull [] array) {
        this.array = Objects.requireNonNull(array);
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (E wlk : this.array) {
            if (!o.equals(wlk)) continue;
            return true;
        }
        return false;
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        return new Itr<E>(this.array);
    }

    @Override
    public Object @NonNull [] toArray() {
        return (Object[])this.array.clone();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.array.length) {
            return Arrays.copyOf(this.array, this.array.length, a.getClass().getComponentType());
        }
        System.arraycopy(this.array, 0, a, 0, this.array.length);
        if (a.length > this.array.length) {
            a[this.array.length] = null;
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (E e : this.array) {
            result = 31 * result + e.hashCode();
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof ConstantArrayCollection)) return false;
        ConstantArrayCollection other = (ConstantArrayCollection)obj;
        if (!Arrays.equals(this.array, other.array)) return false;
        return true;
    }

    public @NonNull String toString() {
        if (this.array.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        int offset = 0;
        while (offset < this.array.length - 1) {
            sb.append(String.valueOf(this.array[offset++])).append(", ");
        }
        return sb.append(String.valueOf(this.array[offset])).append(']').toString();
    }

    private static final class Itr<E>
    extends UnmodifiableIterator<E> {
        private final E @NonNull [] array;
        private int offset = 0;

        Itr(E @NonNull [] array) {
            this.array = array;
        }

        public boolean hasNext() {
            return this.offset < this.array.length;
        }

        public E next() {
            if (this.offset >= this.array.length) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset++];
        }
    }
}

