/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Beta
public final class TopologicalSort {
    private TopologicalSort() {
    }

    public static List<Node> sort(Set<Node> nodes) {
        ArrayList<Node> sortedNodes = new ArrayList<Node>(nodes.size());
        Set<Node> dependentNodes = TopologicalSort.getDependentNodes(nodes);
        while (!dependentNodes.isEmpty()) {
            Node node = dependentNodes.iterator().next();
            dependentNodes.remove(node);
            sortedNodes.add(node);
            for (Edge edge : node.getInEdges()) {
                Node referent = edge.getFrom();
                referent.getOutEdges().remove(edge);
                if (!referent.getOutEdges().isEmpty()) continue;
                dependentNodes.add(referent);
            }
        }
        TopologicalSort.detectCycles(nodes);
        return sortedNodes;
    }

    private static Set<Node> getDependentNodes(Set<Node> nodes) {
        HashSet<Node> dependentNodes = new HashSet<Node>();
        for (Node node : nodes) {
            if (!node.getOutEdges().isEmpty()) continue;
            dependentNodes.add(node);
        }
        return dependentNodes;
    }

    private static void detectCycles(Set<Node> nodes) {
        boolean cycle = false;
        Node cycledNode = null;
        for (Node node : nodes) {
            if (node.getOutEdges().isEmpty()) continue;
            cycle = true;
            cycledNode = node;
            break;
        }
        Preconditions.checkState((!cycle ? 1 : 0) != 0, (Object)("Cycle detected in graph around node: " + String.valueOf(cycledNode)));
    }

    @Beta
    public static interface Node {
        public Set<Edge> getInEdges();

        public Set<Edge> getOutEdges();
    }

    @Beta
    public static interface Edge {
        public Node getFrom();

        public Node getTo();
    }

    @Beta
    public static class EdgeImpl
    implements Edge {
        private final Node from;
        private final Node to;

        public EdgeImpl(Node from, Node to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public Node getFrom() {
            return this.from;
        }

        @Override
        public Node getTo() {
            return this.to;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this.from);
            result = 31 * result + Objects.hashCode(this.to);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EdgeImpl other = (EdgeImpl)obj;
            if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                return false;
            }
            return !(this.to == null ? other.to != null : !this.to.equals(other.to));
        }
    }

    @Beta
    public static class NodeImpl
    implements Node {
        private final Set<Edge> inEdges = new HashSet<Edge>();
        private final Set<Edge> outEdges = new HashSet<Edge>();

        @Override
        public Set<Edge> getInEdges() {
            return this.inEdges;
        }

        @Override
        public Set<Edge> getOutEdges() {
            return this.outEdges;
        }

        public void addEdge(Node to) {
            EdgeImpl edge = new EdgeImpl(this, to);
            this.outEdges.add(edge);
            to.getInEdges().add(edge);
        }
    }
}

