/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.base.MoreObjects;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.WritableObject;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangNamespaceContext;

public final class BiMapYangNamespaceContext
implements YangNamespaceContext,
WritableObject {
    private static final long serialVersionUID = 1L;
    private final ImmutableBiMap<String, QNameModule> mapping;

    public BiMapYangNamespaceContext(BiMap<String, QNameModule> mapping) {
        this.mapping = ImmutableBiMap.copyOf(mapping);
    }

    @Override
    public QNameModule namespaceForPrefix(String prefix) {
        return (QNameModule)this.mapping.get((Object)Objects.requireNonNull(prefix));
    }

    @Override
    public String prefixForNamespace(QNameModule namespace) {
        return (String)this.mapping.inverse().get((Object)Objects.requireNonNull(namespace));
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeInt(this.mapping.size());
        for (Map.Entry entry : this.mapping.entrySet()) {
            out.writeUTF((String)entry.getKey());
            ((QNameModule)entry.getValue()).writeTo(out);
        }
    }

    public static BiMapYangNamespaceContext readFrom(DataInput in) throws IOException {
        int size = in.readInt();
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (int i = 0; i < size; ++i) {
            String prefix = in.readUTF();
            QNameModule namespace = QNameModule.readFrom(in);
            builder.put((Object)prefix, (Object)namespace);
        }
        return new BiMapYangNamespaceContext((BiMap<String, QNameModule>)builder.build());
    }

    public int hashCode() {
        return this.mapping.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof BiMapYangNamespaceContext)) return false;
        BiMapYangNamespaceContext other = (BiMapYangNamespaceContext)obj;
        if (!this.mapping.equals(other.mapping)) return false;
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mapping", this.mapping).toString();
    }
}

