/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.base.Verify;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.WritableObject;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.XNv1;

@NonNullByDefault
public final class XMLNamespace
implements Comparable<XMLNamespace>,
Immutable,
Serializable,
WritableObject {
    private static final long serialVersionUID = 1L;
    private static final Interner<XMLNamespace> INTERNER = Interners.newWeakInterner();
    private final String namespace;

    private XMLNamespace(String namespace) {
        this.namespace = Objects.requireNonNull(namespace);
    }

    public static XMLNamespace of(String namespace) {
        try {
            Verify.verifyNotNull((Object)new URI(namespace));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' is not a valid URI", e);
        }
        return new XMLNamespace(namespace);
    }

    public XMLNamespace intern() {
        return (XMLNamespace)INTERNER.intern((Object)this);
    }

    @Override
    public int compareTo(XMLNamespace o) {
        return this.namespace.compareTo(o.namespace);
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeUTF(this.namespace);
    }

    public static XMLNamespace readFrom(DataInput in) throws IOException {
        try {
            return XMLNamespace.of(in.readUTF());
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Invalid namespace", e);
        }
    }

    public int hashCode() {
        return this.namespace.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof XMLNamespace)) return false;
        XMLNamespace other = (XMLNamespace)obj;
        if (!this.namespace.equals(other.namespace)) return false;
        return true;
    }

    public String toString() {
        return this.namespace;
    }

    Object writeReplace() {
        return new XNv1(this);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Revision.throwNSE();
    }

    private void readObjectNoData() throws ObjectStreamException {
        Revision.throwNSE();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        Revision.throwNSE();
    }
}

