/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.DerivedString;

@Beta
@NonNullByDefault
public abstract class CachingDerivedString<T extends CachingDerivedString<T>>
extends DerivedString<T> {
    private static final long serialVersionUID = 1L;
    private static final VarHandle STR;
    private volatile transient @Nullable String str;

    @SuppressFBWarnings(value={"NP_STORE_INTO_NONNULL_FIELD"})
    protected CachingDerivedString() {
        this.str = null;
    }

    protected CachingDerivedString(String str) {
        this.str = Objects.requireNonNull(str);
    }

    @Override
    public final String toCanonicalString() {
        String local = STR.getAcquire(this);
        return local != null ? local : this.loadCanonicalString();
    }

    private String loadCanonicalString() {
        String computed = this.computeCanonicalString();
        String witness = STR.compareAndExchangeRelease(this, null, computed);
        return witness != null ? witness : computed;
    }

    protected abstract String computeCanonicalString();

    static {
        try {
            STR = MethodHandles.lookup().findVarHandle(CachingDerivedString.class, "str", String.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

