/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.math.BigInteger;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;

@NonNullByDefault
public final class UintConversions {
    private UintConversions() {
    }

    public static Uint8 fromJava(short value) {
        return Uint8.valueOf(value);
    }

    public static Uint16 fromJava(int value) {
        return Uint16.valueOf(value);
    }

    public static Uint32 fromJava(long value) {
        return Uint32.valueOf(value);
    }

    public static Uint64 fromJava(BigInteger value) {
        return Uint64.valueOf(value);
    }

    public static Uint32 fromGuava(UnsignedInteger value) {
        return Uint32.valueOf(value);
    }

    public static Uint64 fromGuava(UnsignedLong value) {
        return Uint64.valueOf(value);
    }

    static void checkNonNegative(byte value, String maxValue) {
        if (value < 0) {
            UintConversions.throwIAE(value, maxValue);
        }
    }

    static void checkNonNegative(short value, String maxStr) {
        if (value < 0) {
            UintConversions.throwIAE(value, maxStr);
        }
    }

    static void checkNonNegative(int value, String maxStr) {
        if (value < 0) {
            UintConversions.throwIAE(value, maxStr);
        }
    }

    static void checkRange(short value, short max) {
        if (value < 0 || value > max) {
            UintConversions.throwIAE((long)value, max);
        }
    }

    static void checkRange(int value, int max) {
        if (value < 0 || value > max) {
            UintConversions.throwIAE((long)value, max);
        }
    }

    static void checkRange(long value, long max) {
        if (value < 0L || value > max) {
            UintConversions.throwIAE(value, max);
        }
    }

    private static void throwIAE(long value, long max) {
        throw new IllegalArgumentException("Invalid range: " + value + ", expected: [[0.." + max + "]].");
    }

    private static void throwIAE(int value, String max) {
        throw new IllegalArgumentException("Invalid range: " + value + ", expected: [[0.." + max + "]].");
    }
}

