/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;

public class OperationFailedException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final List<RpcError> errorList;

    public OperationFailedException(String message, RpcError ... errors) {
        this(message, (Throwable)null, errors);
    }

    public OperationFailedException(String message, Throwable cause, RpcError ... errors) {
        super(Objects.requireNonNull(message), cause);
        this.errorList = errors != null && errors.length > 0 ? ImmutableList.copyOf(Arrays.asList(errors)) : ImmutableList.of((Object)RpcResultBuilder.newError(RpcError.ErrorType.APPLICATION, null, this.getMessage(), null, null, this.getCause()));
    }

    public List<RpcError> getErrorList() {
        return this.errorList;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("message", (Object)this.getMessage()).add("errorList", this.errorList).toString();
    }
}

