/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.stream;

import com.google.common.annotations.Beta;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Objects;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.ExtensibleObject;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriterExtension;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

public interface NormalizedNodeStreamWriter
extends Closeable,
Flushable,
ExtensibleObject<NormalizedNodeStreamWriter, NormalizedNodeStreamWriterExtension> {
    public static final int UNKNOWN_SIZE = -1;

    public void startLeafNode(YangInstanceIdentifier.NodeIdentifier var1) throws IOException;

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier var1, int var2) throws IOException;

    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier var1, int var2) throws IOException;

    public void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> var1) throws IOException;

    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier var1, int var2) throws IOException;

    public void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier var1, int var2) throws IOException;

    public void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier var1, int var2) throws IOException;

    public void startMapNode(YangInstanceIdentifier.NodeIdentifier var1, int var2) throws IOException;

    public void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates var1, int var2) throws IOException;

    public void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier var1, int var2) throws IOException;

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier var1, int var2) throws IOException;

    public void startAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier var1) throws IOException;

    @Beta
    public boolean startAnydataNode(YangInstanceIdentifier.NodeIdentifier var1, Class<?> var2) throws IOException;

    public boolean startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier var1, Class<?> var2) throws IOException;

    public void domSourceValue(DOMSource var1) throws IOException;

    public void endNode() throws IOException;

    default public void nextDataSchemaNode(@NonNull DataSchemaNode schema) {
        Objects.requireNonNull(schema);
    }

    public void scalarValue(@NonNull Object var1) throws IOException;

    @Override
    public void close() throws IOException;

    @Override
    public void flush() throws IOException;
}

