/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema;

import com.google.common.annotations.Beta;
import java.lang.runtime.SwitchBootstraps;
import java.util.Base64;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.PrettyTree;
import org.opendaylight.yangtools.concepts.PrettyTreeAware;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.data.api.schema.ForeignDataNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.ValueNode;

@Beta
public final class NormalizedNodePrettyTree
extends PrettyTree
implements Immutable {
    private final @NonNull NormalizedNode node;

    public NormalizedNodePrettyTree(@NonNull NormalizedNode node) {
        this.node = Objects.requireNonNull(node);
    }

    public void appendTo(StringBuilder sb, int depth) {
        NormalizedNodePrettyTree.appendNode(sb, depth, null, this.node);
    }

    private static void appendNode(StringBuilder sb, int depth, QNameModule parentNamespace, NormalizedNode node) {
        String simpleName = node.contract().getSimpleName();
        NormalizedNodePrettyTree.appendIndent((StringBuilder)sb, (int)depth);
        sb.append(simpleName.toLowerCase(Locale.ROOT).charAt(0)).append(simpleName, 1, simpleName.length()).append(' ');
        QName qname = node.name().getNodeType();
        QNameModule currentNamespace = qname.getModule();
        NormalizedNodePrettyTree.appendNamespace(sb, parentNamespace, currentNamespace);
        sb.append(qname.getLocalName()).append(' ');
        NormalizedNode normalizedNode = node;
        Objects.requireNonNull(normalizedNode);
        NormalizedNode normalizedNode2 = normalizedNode;
        int n = 0;
        block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NormalizedNodeContainer.class, ValueNode.class, ForeignDataNode.class}, (Object)normalizedNode2, n)) {
            case 0: {
                NormalizedNodeContainer container = (NormalizedNodeContainer)normalizedNode2;
                sb.append("= {");
                Iterator it = container.body().iterator();
                if (it.hasNext()) {
                    int childIndent = depth + 1;
                    do {
                        sb.append('\n');
                        NormalizedNodePrettyTree.appendNode(sb, childIndent, currentNamespace, (NormalizedNode)it.next());
                    } while (it.hasNext());
                    sb.append('\n');
                    NormalizedNodePrettyTree.appendIndent((StringBuilder)sb, (int)depth);
                }
                sb.append('}');
                break;
            }
            case 1: {
                Object value;
                ValueNode valueNode = (ValueNode)normalizedNode2;
                sb.append("= ");
                Object v = value = valueNode.body();
                Objects.requireNonNull(v);
                Object v2 = v;
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{byte[].class, String.class}, v2, n2)) {
                    case 0: {
                        byte[] bytes = (byte[])v2;
                        sb.append("(byte[])").append(Base64.getEncoder().encodeToString(bytes));
                        break block0;
                    }
                    case 1: {
                        String str = (String)v2;
                        NormalizedNodePrettyTree.appendString(sb, str);
                        break block0;
                    }
                }
                sb.append(value);
                break;
            }
            case 2: {
                ForeignDataNode data = (ForeignDataNode)normalizedNode2;
                Object v = data.body();
                Objects.requireNonNull(v);
                Object v3 = v;
                int n3 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PrettyTreeAware.class}, v3, n3)) {
                    case 0: {
                        PrettyTreeAware body = (PrettyTreeAware)v3;
                        sb.append("= {\n");
                        body.prettyTree().appendTo(sb, depth + 1);
                        NormalizedNodePrettyTree.appendIndent((StringBuilder)sb, (int)depth);
                        sb.append('}');
                        break block0;
                    }
                }
                sb.append("= (").append(data.bodyObjectModel().getName()).append(')');
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled node " + String.valueOf(node));
            }
        }
    }

    private static boolean appendNamespace(StringBuilder sb, QNameModule parent, QNameModule current) {
        if (!current.equals((Object)parent)) {
            sb.append('(').append(current.namespace());
            Revision rev = current.revision();
            if (rev != null) {
                sb.append('@').append(rev);
            }
            sb.append(')');
            return true;
        }
        return false;
    }

    private static void appendString(StringBuilder sb, String str) {
        sb.append('\"').append(str).append('\"');
    }
}

