/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema;

import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DuplicateEntry;
import org.opendaylight.yangtools.yang.data.api.schema.DuplicateFinder;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

@Beta
public final class NormalizedNodes {
    private static final int STRINGTREE_INDENT = 4;

    private NormalizedNodes() {
    }

    public static Map<NormalizedNode, DuplicateEntry> findDuplicates(@NonNull NormalizedNode node) {
        return Maps.filterValues(DuplicateFinder.findDuplicates(node), input -> !input.getDuplicates().isEmpty());
    }

    public static Optional<NormalizedNode> findNode(YangInstanceIdentifier rootPath, NormalizedNode rootNode, YangInstanceIdentifier childPath) {
        Optional<YangInstanceIdentifier> relativePath = childPath.relativeTo(rootPath);
        return relativePath.isPresent() ? NormalizedNodes.findNode(rootNode, relativePath.orElseThrow()) : Optional.empty();
    }

    public static Optional<NormalizedNode> findNode(Optional<NormalizedNode> parent, Iterable<YangInstanceIdentifier.PathArgument> relativePath) {
        Iterator<YangInstanceIdentifier.PathArgument> pathIterator = Objects.requireNonNull(relativePath, "Relative path must not be null").iterator();
        Optional<NormalizedNode> currentNode = Objects.requireNonNull(parent, "Parent must not be null");
        while (currentNode.isPresent() && pathIterator.hasNext()) {
            currentNode = NormalizedNodes.getDirectChild(currentNode.orElseThrow(), pathIterator.next());
        }
        return currentNode;
    }

    public static Optional<NormalizedNode> findNode(Optional<NormalizedNode> parent, YangInstanceIdentifier.PathArgument pathArg) {
        return parent.flatMap(node -> NormalizedNodes.getDirectChild(node, pathArg));
    }

    public static Optional<NormalizedNode> findNode(Optional<NormalizedNode> parent, YangInstanceIdentifier.PathArgument ... relativePath) {
        return NormalizedNodes.findNode(parent, Arrays.asList(relativePath));
    }

    public static Optional<NormalizedNode> findNode(@Nullable NormalizedNode parent, YangInstanceIdentifier.PathArgument pathArg) {
        return parent == null ? Optional.empty() : NormalizedNodes.getDirectChild(parent, pathArg);
    }

    public static Optional<NormalizedNode> findNode(NormalizedNode parent, Iterable<YangInstanceIdentifier.PathArgument> relativePath) {
        return NormalizedNodes.findNode(Optional.ofNullable(parent), relativePath);
    }

    public static Optional<NormalizedNode> findNode(NormalizedNode parent, SchemaNodeIdentifier.Descendant path) {
        return NormalizedNodes.findNode(Optional.ofNullable(parent), (Iterable<YangInstanceIdentifier.PathArgument>)Lists.transform((List)path.getNodeIdentifiers(), YangInstanceIdentifier.NodeIdentifier::new));
    }

    public static Optional<NormalizedNode> findNode(NormalizedNode parent, YangInstanceIdentifier.PathArgument ... relativePath) {
        return NormalizedNodes.findNode(parent, Arrays.asList(relativePath));
    }

    public static Optional<NormalizedNode> findNode(NormalizedNode tree, YangInstanceIdentifier path) {
        return NormalizedNodes.findNode(Optional.of(Objects.requireNonNull(tree, "Tree must not be null")), Objects.requireNonNull(path, "Path must not be null").getPathArguments());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Optional<NormalizedNode> getDirectChild(NormalizedNode node, YangInstanceIdentifier.PathArgument pathArg) {
        Object child;
        if (node instanceof DataContainerNode) {
            DataContainerNode dataContainer = (DataContainerNode)node;
            if (pathArg instanceof YangInstanceIdentifier.NodeIdentifier) {
                YangInstanceIdentifier.NodeIdentifier nid = (YangInstanceIdentifier.NodeIdentifier)pathArg;
                child = dataContainer.childByArg(nid);
                return Optional.ofNullable(child);
            }
        }
        if (node instanceof MapNode) {
            MapNode map = (MapNode)node;
            if (pathArg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
                YangInstanceIdentifier.NodeIdentifierWithPredicates nip = (YangInstanceIdentifier.NodeIdentifierWithPredicates)pathArg;
                child = map.childByArg(nip);
                return Optional.ofNullable(child);
            }
        }
        if (node instanceof LeafSetNode) {
            LeafSetNode leafSet = (LeafSetNode)node;
            if (pathArg instanceof YangInstanceIdentifier.NodeWithValue) {
                YangInstanceIdentifier.NodeWithValue nwv = (YangInstanceIdentifier.NodeWithValue)pathArg;
                child = leafSet.childByArg(nwv);
                return Optional.ofNullable(child);
            }
        }
        child = null;
        return Optional.ofNullable(child);
    }

    public static String toStringTree(NormalizedNode node) {
        StringBuilder sb = new StringBuilder();
        NormalizedNodes.toStringTree(sb, node, 0);
        return sb.toString();
    }

    private static void toStringTree(StringBuilder sb, NormalizedNode node, int offset) {
        String prefix = " ".repeat(offset);
        NormalizedNodes.appendPathArgument(sb.append(prefix), node.name());
        if (node instanceof NormalizedNodeContainer) {
            NormalizedNodeContainer container = (NormalizedNodeContainer)node;
            sb.append(" {\n");
            Iterator iterator = container.body().iterator();
            while (iterator.hasNext()) {
                NormalizedNode child = (NormalizedNode)iterator.next();
                NormalizedNodes.toStringTree(sb, child, offset + 4);
            }
            sb.append(prefix).append('}');
        } else {
            sb.append(' ').append(node.body());
        }
        sb.append('\n');
    }

    private static void appendPathArgument(StringBuilder sb, YangInstanceIdentifier.PathArgument arg) {
        sb.append(arg.getNodeType().getLocalName());
        if (arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            YangInstanceIdentifier.NodeIdentifierWithPredicates nip = (YangInstanceIdentifier.NodeIdentifierWithPredicates)arg;
            sb.append(nip.values());
        }
    }
}

