/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.stream;

import com.google.common.annotations.Beta;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedMetadata;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriterMetadataDecorator;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;

@Beta
public final class NormalizedMetadataWriter
implements Closeable,
Flushable {
    private final NormalizedNodeStreamWriter writer;
    private final boolean orderKeyLeaves;

    private NormalizedMetadataWriter(NormalizedNodeStreamWriter writer, boolean orderKeyLeaves) {
        this.writer = Objects.requireNonNull(writer);
        this.orderKeyLeaves = orderKeyLeaves;
    }

    public static @NonNull NormalizedMetadataWriter forStreamWriter(NormalizedNodeStreamWriter writer, boolean orderKeyLeaves) {
        return new NormalizedMetadataWriter(writer, orderKeyLeaves);
    }

    public static @NonNull NormalizedMetadataWriter forStreamWriter(NormalizedNodeStreamWriter writer) {
        return NormalizedMetadataWriter.forStreamWriter(writer, true);
    }

    public @NonNull NormalizedMetadataWriter write(NormalizedNode data, NormalizedMetadata metadata) throws IOException {
        NormalizedNodeStreamWriter.MetadataExtension metaWriter = (NormalizedNodeStreamWriter.MetadataExtension)this.writer.extension(NormalizedNodeStreamWriter.MetadataExtension.class);
        NormalizedNodeStreamWriter delegate = metaWriter == null ? this.writer : new NormalizedNodeStreamWriterMetadataDecorator(this.writer, metaWriter, metadata);
        NormalizedNodeWriter nnWriter = NormalizedNodeWriter.forStreamWriter(delegate, this.orderKeyLeaves);
        nnWriter.write(data);
        nnWriter.flush();
        return this;
    }

    @Override
    public void close() throws IOException {
        try {
            this.writer.flush();
        }
        finally {
            this.writer.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }
}

