/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.binfmt;

import com.google.common.base.Preconditions;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointIdentifier;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.binfmt.AbstractNormalizedNodeDataOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractMagnesiumDataOutput
extends AbstractNormalizedNodeDataOutput {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMagnesiumDataOutput.class);
    private static final Object KEY_LEAF_STATE = new Object();
    private static final Object NO_ENDNODE_STATE = new Object();
    private static final TransformerFactory TF = TransformerFactory.newInstance();
    private final Deque<Object> stack = new ArrayDeque<Object>();
    private final Map<YangInstanceIdentifier.AugmentationIdentifier, Integer> aidCodeMap = new HashMap<YangInstanceIdentifier.AugmentationIdentifier, Integer>();
    private final Map<QNameModule, Integer> moduleCodeMap = new HashMap<QNameModule, Integer>();
    private final Map<String, Integer> stringCodeMap = new HashMap<String, Integer>();
    private final Map<QName, Integer> qnameCodeMap = new HashMap<QName, Integer>();

    AbstractMagnesiumDataOutput(DataOutput output) {
        super(output);
    }

    public final void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) throws IOException {
        QName qname;
        YangInstanceIdentifier.NodeIdentifierWithPredicates nip;
        Object current = this.stack.peek();
        if (current instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates && (nip = (YangInstanceIdentifier.NodeIdentifierWithPredicates)current).containsKey(qname = name.getNodeType())) {
            this.writeQNameNode(65, qname);
            this.stack.push(KEY_LEAF_STATE);
            return;
        }
        this.startSimpleNode((byte)1, (YangInstanceIdentifier.PathArgument)name);
    }

    public final void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.startQNameNode((byte)6, (YangInstanceIdentifier.PathArgument)name);
    }

    public final void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.startQNameNode((byte)7, (YangInstanceIdentifier.PathArgument)name);
    }

    public final void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) throws IOException {
        if (this.matchesParentQName(name.getNodeType())) {
            this.output.writeByte(12);
            this.stack.push(NO_ENDNODE_STATE);
        } else {
            this.startSimpleNode((byte)12, (YangInstanceIdentifier.PathArgument)name);
        }
    }

    public final void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.startQNameNode((byte)2, (YangInstanceIdentifier.PathArgument)name);
    }

    public final void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.startQNameNode((byte)3, (YangInstanceIdentifier.PathArgument)name);
    }

    public final void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.startInheritedNode((byte)11, (YangInstanceIdentifier.PathArgument)name);
    }

    public final void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.startQNameNode((byte)4, (YangInstanceIdentifier.PathArgument)name);
    }

    public final void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) throws IOException {
        int size = identifier.size();
        if (size == 1) {
            this.startInheritedNode((byte)77, (YangInstanceIdentifier.PathArgument)identifier);
        } else if (size == 0) {
            this.startInheritedNode((byte)13, (YangInstanceIdentifier.PathArgument)identifier);
        } else if (size < 256) {
            this.startInheritedNode((byte)-115, (YangInstanceIdentifier.PathArgument)identifier);
            this.output.writeByte(size);
        } else {
            this.startInheritedNode((byte)-51, (YangInstanceIdentifier.PathArgument)identifier);
            this.output.writeInt(size);
        }
        this.writePredicates(identifier);
    }

    public final void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.startQNameNode((byte)5, (YangInstanceIdentifier.PathArgument)name);
    }

    public final void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.startQNameNode((byte)8, (YangInstanceIdentifier.PathArgument)name);
    }

    public final void startAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier identifier) throws IOException {
        Integer code = this.aidCodeMap.get(identifier);
        if (code == null) {
            this.aidCodeMap.put(identifier, this.aidCodeMap.size());
            this.output.writeByte(25);
            Set qnames = identifier.getPossibleChildNames();
            this.output.writeInt(qnames.size());
            for (QName qname : qnames) {
                this.writeQNameInternal(qname);
            }
        } else {
            this.writeNodeType(9, code);
        }
        this.stack.push(identifier);
    }

    public final boolean startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) throws IOException {
        if (DOMSource.class.isAssignableFrom(objectModel)) {
            this.startSimpleNode((byte)10, (YangInstanceIdentifier.PathArgument)name);
            return true;
        }
        return false;
    }

    public final void domSourceValue(DOMSource value) throws IOException {
        StringWriter writer = new StringWriter();
        try {
            TF.newTransformer().transform(value, new StreamResult(writer));
        }
        catch (TransformerException e) {
            throw new IOException("Error writing anyXml", e);
        }
        this.writeValue(writer.toString());
    }

    public final void endNode() throws IOException {
        if (this.stack.pop() instanceof YangInstanceIdentifier.PathArgument) {
            this.output.writeByte(0);
        }
    }

    public final void scalarValue(Object value) throws IOException {
        if (KEY_LEAF_STATE.equals(this.stack.peek())) {
            LOG.trace("Inside a map entry key leaf, not emitting value {}", value);
        } else {
            this.writeObject(value);
        }
    }

    @Override
    final void writeQNameInternal(QName qname) throws IOException {
        Integer code = this.qnameCodeMap.get(qname);
        if (code == null) {
            this.output.writeByte(22);
            this.encodeQName(qname);
        } else {
            this.writeQNameRef(code);
        }
    }

    @Override
    final void writePathArgumentInternal(YangInstanceIdentifier.PathArgument pathArgument) throws IOException {
        if (pathArgument instanceof YangInstanceIdentifier.NodeIdentifier) {
            YangInstanceIdentifier.NodeIdentifier nid = (YangInstanceIdentifier.NodeIdentifier)pathArgument;
            this.writeNodeIdentifier(nid);
        } else if (pathArgument instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            YangInstanceIdentifier.NodeIdentifierWithPredicates nip = (YangInstanceIdentifier.NodeIdentifierWithPredicates)pathArgument;
            this.writeNodeIdentifierWithPredicates(nip);
        } else if (pathArgument instanceof YangInstanceIdentifier.AugmentationIdentifier) {
            YangInstanceIdentifier.AugmentationIdentifier augid = (YangInstanceIdentifier.AugmentationIdentifier)pathArgument;
            this.writeAugmentationIdentifier(augid);
        } else if (pathArgument instanceof YangInstanceIdentifier.NodeWithValue) {
            YangInstanceIdentifier.NodeWithValue niv = (YangInstanceIdentifier.NodeWithValue)pathArgument;
            this.writeNodeWithValue(niv);
        } else if (pathArgument instanceof MountPointIdentifier) {
            MountPointIdentifier mpid = (MountPointIdentifier)pathArgument;
            this.writeMountPointIdentifier(mpid);
        } else {
            throw new IOException("Unhandled PathArgument " + pathArgument);
        }
    }

    private void writeAugmentationIdentifier(YangInstanceIdentifier.AugmentationIdentifier identifier) throws IOException {
        Set qnames = identifier.getPossibleChildNames();
        int size = qnames.size();
        if (size < 29) {
            this.output.writeByte(0 | size << 3);
        } else if (size < 256) {
            this.output.writeByte(-24);
            this.output.writeByte(size);
        } else if (size < 65536) {
            this.output.writeByte(-16);
            this.output.writeShort(size);
        } else {
            this.output.writeByte(-8);
            this.output.writeInt(size);
        }
        for (QName qname : qnames) {
            this.writeQNameInternal(qname);
        }
    }

    private void writeNodeIdentifier(YangInstanceIdentifier.NodeIdentifier identifier) throws IOException {
        this.writePathArgumentQName(identifier.getNodeType(), (byte)1);
    }

    private void writeMountPointIdentifier(MountPointIdentifier identifier) throws IOException {
        this.writePathArgumentQName(identifier.getNodeType(), (byte)4);
    }

    private void writeNodeIdentifierWithPredicates(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier) throws IOException {
        int size = identifier.size();
        if (size < 5) {
            this.writePathArgumentQName(identifier.getNodeType(), (byte)(2 | size << 5));
        } else if (size < 256) {
            this.writePathArgumentQName(identifier.getNodeType(), (byte)-94);
            this.output.writeByte(size);
        } else if (size < 65536) {
            this.writePathArgumentQName(identifier.getNodeType(), (byte)-62);
            this.output.writeShort(size);
        } else {
            this.writePathArgumentQName(identifier.getNodeType(), (byte)-30);
            this.output.writeInt(size);
        }
        this.writePredicates(identifier);
    }

    private void writePredicates(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier) throws IOException {
        for (Map.Entry e : identifier.entrySet()) {
            this.writeQNameInternal((QName)e.getKey());
            this.writeObject(e.getValue());
        }
    }

    private void writeNodeWithValue(YangInstanceIdentifier.NodeWithValue<?> identifier) throws IOException {
        this.writePathArgumentQName(identifier.getNodeType(), (byte)3);
        this.writeObject(identifier.getValue());
    }

    private void writePathArgumentQName(QName qname, byte typeHeader) throws IOException {
        Integer code = this.qnameCodeMap.get(qname);
        if (code != null) {
            int val = code;
            if (val < 256) {
                this.output.writeByte(typeHeader | 8);
                this.output.writeByte(val);
            } else if (val < 65792) {
                this.output.writeByte(typeHeader | 0x10);
                this.output.writeShort(val - 256);
            } else {
                this.output.writeByte(typeHeader | 0x18);
                this.output.writeInt(val);
            }
        } else {
            this.output.writeByte(typeHeader);
            this.encodeQName(qname);
        }
    }

    @Override
    final void writeYangInstanceIdentifierInternal(YangInstanceIdentifier identifier) throws IOException {
        this.writeValue(identifier);
    }

    private void writeObject(@NonNull Object value) throws IOException {
        if (value instanceof String) {
            String str = (String)value;
            this.writeValue(str);
        } else if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            this.writeValue(bool);
        } else if (value instanceof Byte) {
            Byte byteVal = (Byte)value;
            this.writeValue(byteVal);
        } else if (value instanceof Short) {
            Short shortVal = (Short)value;
            this.writeValue(shortVal);
        } else if (value instanceof Integer) {
            Integer intVal = (Integer)value;
            this.writeValue(intVal);
        } else if (value instanceof Long) {
            Long longVal = (Long)value;
            this.writeValue(longVal);
        } else if (value instanceof Uint8) {
            Uint8 uint8 = (Uint8)value;
            this.writeValue(uint8);
        } else if (value instanceof Uint16) {
            Uint16 uint16 = (Uint16)value;
            this.writeValue(uint16);
        } else if (value instanceof Uint32) {
            Uint32 uint32 = (Uint32)value;
            this.writeValue(uint32);
        } else if (value instanceof Uint64) {
            Uint64 uint64 = (Uint64)value;
            this.writeValue(uint64);
        } else if (value instanceof QName) {
            QName qname = (QName)value;
            this.writeQNameInternal(qname);
        } else if (value instanceof YangInstanceIdentifier) {
            YangInstanceIdentifier id = (YangInstanceIdentifier)value;
            this.writeValue(id);
        } else if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            this.writeValue(bytes);
        } else if (value instanceof Empty) {
            this.output.writeByte(2);
        } else if (value instanceof Set) {
            Set set = (Set)value;
            this.writeValue(set);
        } else if (value instanceof BigDecimal || value instanceof Decimal64) {
            this.output.writeByte(29);
            this.output.writeUTF(value.toString());
        } else if (value instanceof BigInteger) {
            BigInteger val = (BigInteger)value;
            this.writeValue(val);
        } else {
            throw new IOException("Unhandled value type " + value.getClass());
        }
    }

    private void writeValue(boolean value) throws IOException {
        this.output.writeByte(value ? 1 : 0);
    }

    private void writeValue(byte value) throws IOException {
        if (value != 0) {
            this.output.writeByte(3);
            this.output.writeByte(value);
        } else {
            this.output.writeByte(32);
        }
    }

    private void writeValue(short value) throws IOException {
        if (value != 0) {
            this.output.writeByte(4);
            this.output.writeShort(value);
        } else {
            this.output.writeByte(33);
        }
    }

    private void writeValue(int value) throws IOException {
        if ((value & 0xFFFF0000) != 0) {
            this.output.writeByte(5);
            this.output.writeInt(value);
        } else if (value != 0) {
            this.output.writeByte(41);
            this.output.writeShort(value);
        } else {
            this.output.writeByte(34);
        }
    }

    private void writeValue(long value) throws IOException {
        if ((value & 0xFFFFFFFF00000000L) != 0L) {
            this.output.writeByte(6);
            this.output.writeLong(value);
        } else if (value != 0L) {
            this.output.writeByte(43);
            this.output.writeInt((int)value);
        } else {
            this.output.writeByte(35);
        }
    }

    private void writeValue(Uint8 value) throws IOException {
        byte b = value.byteValue();
        if (b != 0) {
            this.output.writeByte(7);
            this.output.writeByte(b);
        } else {
            this.output.writeByte(36);
        }
    }

    private void writeValue(Uint16 value) throws IOException {
        short s = value.shortValue();
        if (s != 0) {
            this.output.writeByte(8);
            this.output.writeShort(s);
        } else {
            this.output.writeByte(37);
        }
    }

    private void writeValue(Uint32 value) throws IOException {
        int i = value.intValue();
        if ((i & 0xFFFF0000) != 0) {
            this.output.writeByte(9);
            this.output.writeInt(i);
        } else if (i != 0) {
            this.output.writeByte(42);
            this.output.writeShort(i);
        } else {
            this.output.writeByte(38);
        }
    }

    private void writeValue(Uint64 value) throws IOException {
        long l = value.longValue();
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            this.output.writeByte(10);
            this.output.writeLong(l);
        } else if (l != 0L) {
            this.output.writeByte(44);
            this.output.writeInt((int)l);
        } else {
            this.output.writeByte(39);
        }
    }

    abstract void writeValue(BigInteger var1) throws IOException;

    private void writeValue(String value) throws IOException {
        if (value.isEmpty()) {
            this.output.writeByte(40);
        } else if (value.length() <= 16383) {
            this.output.writeByte(11);
            this.output.writeUTF(value);
        } else if (value.length() <= 0x100000) {
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            if (bytes.length < 65536) {
                this.output.writeByte(12);
                this.output.writeShort(bytes.length);
            } else {
                this.output.writeByte(13);
                this.output.writeInt(bytes.length);
            }
            this.output.write(bytes);
        } else {
            this.output.writeByte(14);
            this.output.writeInt(value.length());
            this.output.writeChars(value);
        }
    }

    private void writeValue(byte[] value) throws IOException {
        if (value.length < 128) {
            this.output.writeByte(-128 + value.length);
        } else if (value.length < 384) {
            this.output.writeByte(18);
            this.output.writeByte(value.length - 128);
        } else if (value.length < 65920) {
            this.output.writeByte(19);
            this.output.writeShort(value.length - 384);
        } else {
            this.output.writeByte(20);
            this.output.writeInt(value.length);
        }
        this.output.write(value);
    }

    private void writeValue(YangInstanceIdentifier value) throws IOException {
        List args = value.getPathArguments();
        int size = args.size();
        if (size > 31) {
            this.output.writeByte(21);
            this.output.writeInt(size);
        } else {
            this.output.writeByte(96 + size);
        }
        for (YangInstanceIdentifier.PathArgument arg : args) {
            this.writePathArgumentInternal(arg);
        }
    }

    private void writeValue(Set<?> value) throws IOException {
        int size = value.size();
        if (size < 29) {
            this.output.writeByte(64 + size);
        } else if (size < 285) {
            this.output.writeByte(93);
            this.output.writeByte(size - 29);
        } else if (size < 65821) {
            this.output.writeByte(94);
            this.output.writeShort(size - 285);
        } else {
            this.output.writeByte(95);
            this.output.writeInt(size);
        }
        for (Object bit : value) {
            Preconditions.checkArgument((boolean)(bit instanceof String), (String)"Expected value type to be String but was %s", bit);
            this.encodeString((String)bit);
        }
    }

    private boolean matchesParentQName(QName qname) {
        YangInstanceIdentifier.NodeIdentifier nid;
        Object current = this.stack.peek();
        return current instanceof YangInstanceIdentifier.NodeIdentifier && qname.equals((Object)(nid = (YangInstanceIdentifier.NodeIdentifier)current).getNodeType());
    }

    private void startInheritedNode(byte type, YangInstanceIdentifier.PathArgument name) throws IOException {
        QName qname = name.getNodeType();
        if (this.matchesParentQName(qname)) {
            this.output.write(type);
        } else {
            this.writeQNameNode(type, qname);
        }
        this.stack.push(name);
    }

    private void startQNameNode(byte type, YangInstanceIdentifier.PathArgument name) throws IOException {
        this.writeQNameNode(type, name.getNodeType());
        this.stack.push(name);
    }

    private void startSimpleNode(byte type, YangInstanceIdentifier.PathArgument name) throws IOException {
        this.writeQNameNode(type, name.getNodeType());
        this.stack.push(NO_ENDNODE_STATE);
    }

    private void writeQNameNode(int type, @NonNull QName qname) throws IOException {
        Integer code = this.qnameCodeMap.get(qname);
        if (code == null) {
            this.output.writeByte(type | 0x10);
            this.encodeQName(qname);
        } else {
            this.writeNodeType(type, code);
        }
    }

    private void writeNodeType(int type, int code) throws IOException {
        if (code <= 255) {
            this.output.writeByte(type | 0x20);
            this.output.writeByte(code);
        } else {
            this.output.writeByte(type | 0x30);
            this.output.writeInt(code);
        }
    }

    private void encodeQName(@NonNull QName qname) throws IOException {
        Integer prev = this.qnameCodeMap.put(qname, this.qnameCodeMap.size());
        if (prev != null) {
            throw new IOException("Internal coding error: attempted to re-encode " + qname + "%s already encoded as " + prev);
        }
        QNameModule module = qname.getModule();
        Integer code = this.moduleCodeMap.get(module);
        if (code == null) {
            this.moduleCodeMap.put(module, this.moduleCodeMap.size());
            this.encodeString(module.getNamespace().toString());
            Optional rev = module.getRevision();
            if (rev.isPresent()) {
                this.encodeString(((Revision)rev.get()).toString());
            } else {
                this.output.writeByte(40);
            }
        } else {
            this.writeModuleRef(code);
        }
        this.encodeString(qname.getLocalName());
    }

    private void encodeString(@NonNull String str) throws IOException {
        Integer code = this.stringCodeMap.get(str);
        if (code != null) {
            this.writeRef(code);
        } else {
            this.stringCodeMap.put(str, this.stringCodeMap.size());
            this.writeValue(str);
        }
    }

    private void writeQNameRef(int code) throws IOException {
        int val = code;
        if (val < 256) {
            this.output.writeByte(23);
            this.output.writeByte(val);
        } else if (val < 65792) {
            this.output.writeByte(24);
            this.output.writeShort(val - 256);
        } else {
            this.output.writeByte(25);
            this.output.writeInt(val);
        }
    }

    private void writeRef(int code) throws IOException {
        int val = code;
        if (val < 256) {
            this.output.writeByte(15);
            this.output.writeByte(val);
        } else if (val < 65792) {
            this.output.writeByte(16);
            this.output.writeShort(val - 256);
        } else {
            this.output.writeByte(17);
            this.output.writeInt(val);
        }
    }

    private void writeModuleRef(int code) throws IOException {
        int val = code;
        if (val < 256) {
            this.output.writeByte(26);
            this.output.writeByte(val);
        } else if (val < 65792) {
            this.output.writeByte(27);
            this.output.writeShort(val - 256);
        } else {
            this.output.writeByte(28);
            this.output.writeInt(val);
        }
    }
}

