/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.binfmt;

import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.binfmt.AbstractLithiumDataOutput;

final class NeonSR2NormalizedNodeOutputStreamWriter
extends AbstractLithiumDataOutput {
    private final Map<YangInstanceIdentifier.AugmentationIdentifier, Integer> aidCodeMap = new HashMap<YangInstanceIdentifier.AugmentationIdentifier, Integer>();
    private final Map<QNameModule, Integer> moduleCodeMap = new HashMap<QNameModule, Integer>();
    private final Map<QName, Integer> qnameCodeMap = new HashMap<QName, Integer>();

    NeonSR2NormalizedNodeOutputStreamWriter(DataOutput output) {
        super(output);
    }

    @Override
    short streamVersion() {
        return 2;
    }

    @Override
    void writeQNameInternal(QName qname) throws IOException {
        Integer value = this.qnameCodeMap.get(qname);
        if (value == null) {
            this.qnameCodeMap.put(qname, this.qnameCodeMap.size());
            this.writeByte(5);
            this.defaultWriteQName(qname);
        } else {
            this.writeByte(4);
            this.writeInt(value);
        }
    }

    @Override
    void writeAugmentationIdentifier(YangInstanceIdentifier.AugmentationIdentifier aid) throws IOException {
        Integer value = this.aidCodeMap.get(aid);
        if (value == null) {
            this.aidCodeMap.put(aid, this.aidCodeMap.size());
            this.writeByte(7);
            this.defaultWriteAugmentationIdentifier(aid);
        } else {
            this.writeByte(6);
            this.writeInt(value);
        }
    }

    @Override
    void writeModule(QNameModule module) throws IOException {
        Integer value = this.moduleCodeMap.get(module);
        if (value == null) {
            this.moduleCodeMap.put(module, this.moduleCodeMap.size());
            this.writeByte(9);
            this.defaultWriteModule(module);
        } else {
            this.writeByte(8);
            this.writeInt(value);
        }
    }
}

