/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.binfmt;

import java.io.DataInput;
import java.io.IOException;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.ReusableStreamReceiver;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;
import org.opendaylight.yangtools.yang.data.codec.binfmt.VersionedNormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.impl.schema.ReusableImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

public interface NormalizedNodeDataInput
extends QName.QNameAwareDataInput {
    public void streamNormalizedNode(NormalizedNodeStreamWriter var1) throws IOException;

    default public NormalizedNode readNormalizedNode() throws IOException {
        return this.readNormalizedNode((ReusableStreamReceiver)ReusableImmutableNormalizedNodeStreamWriter.create());
    }

    default public NormalizedNode readNormalizedNode(ReusableStreamReceiver receiver) throws IOException {
        try {
            this.streamNormalizedNode((NormalizedNodeStreamWriter)receiver);
            NormalizedNode normalizedNode = receiver.getResult();
            return normalizedNode;
        }
        finally {
            receiver.reset();
        }
    }

    public YangInstanceIdentifier readYangInstanceIdentifier() throws IOException;

    public YangInstanceIdentifier.PathArgument readPathArgument() throws IOException;

    public SchemaNodeIdentifier readSchemaNodeIdentifier() throws IOException;

    public NormalizedNodeStreamVersion getVersion() throws IOException;

    default public Optional<NormalizedNode> readOptionalNormalizedNode() throws IOException {
        return this.readBoolean() ? Optional.of(this.readNormalizedNode()) : Optional.empty();
    }

    public static @NonNull NormalizedNodeDataInput newDataInput(@NonNull DataInput input) throws IOException {
        return new VersionedNormalizedNodeDataInput(input).delegate();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public static @NonNull NormalizedNodeDataInput newDataInputWithoutValidation(@NonNull DataInput input) {
        return new VersionedNormalizedNodeDataInput(input);
    }
}

