/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.binfmt;

import java.io.DataInput;
import java.io.IOException;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Either;
import org.opendaylight.yangtools.yang.common.QNameAwareDataInput;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizationResult;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.ReusableStreamReceiver;
import org.opendaylight.yangtools.yang.data.codec.binfmt.LegacyPathArgument;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;
import org.opendaylight.yangtools.yang.data.codec.binfmt.VersionedNormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.impl.schema.ReusableImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

public interface NormalizedNodeDataInput
extends QNameAwareDataInput {
    public void streamNormalizedNode(NormalizedNodeStreamWriter var1) throws IOException;

    default public NormalizedNode readNormalizedNode() throws IOException {
        return this.readNormalizedNode((ReusableStreamReceiver)ReusableImmutableNormalizedNodeStreamWriter.create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public NormalizedNode readNormalizedNode(ReusableStreamReceiver receiver) throws IOException {
        try {
            this.streamNormalizedNode((NormalizedNodeStreamWriter)receiver);
            NormalizationResult result = receiver.result();
            NormalizedNode normalizedNode = result != null ? result.data() : null;
            return normalizedNode;
        }
        finally {
            receiver.reset();
        }
    }

    public @NonNull YangInstanceIdentifier readYangInstanceIdentifier() throws IOException;

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.PathArgument readPathArgument() throws IOException;

    @Deprecated(since="11.0.0")
    public @NonNull Either<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.PathArgument, LegacyPathArgument> readLegacyPathArgument() throws IOException;

    public @NonNull SchemaNodeIdentifier readSchemaNodeIdentifier() throws IOException;

    public @NonNull NormalizedNodeStreamVersion getVersion() throws IOException;

    default public Optional<NormalizedNode> readOptionalNormalizedNode() throws IOException {
        return this.readBoolean() ? Optional.of(this.readNormalizedNode()) : Optional.empty();
    }

    public static @NonNull NormalizedNodeDataInput newDataInput(@NonNull DataInput input) throws IOException {
        return new VersionedNormalizedNodeDataInput(input).delegate();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public static @NonNull NormalizedNodeDataInput newDataInputWithoutValidation(@NonNull DataInput input) {
        return new VersionedNormalizedNodeDataInput(input);
    }
}

