/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.binfmt;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.DataInput;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Either;
import org.opendaylight.yangtools.concepts.WritableObjects;
import org.opendaylight.yangtools.util.xml.UntrustedXML;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.binfmt.AbstractNormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.InvalidNormalizedNodeStreamException;
import org.opendaylight.yangtools.yang.data.codec.binfmt.LegacyPathArgument;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;
import org.opendaylight.yangtools.yang.data.codec.binfmt.QNameFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class PotassiumDataInput
extends AbstractNormalizedNodeDataInput {
    private static final Logger LOG = LoggerFactory.getLogger(PotassiumDataInput.class);
    private static final @NonNull Byte INT8_0 = 0;
    private static final @NonNull Short INT16_0 = 0;
    private static final @NonNull Integer INT32_0 = 0;
    private static final @NonNull Long INT64_0 = 0L;
    private static final byte @NonNull [] BINARY_0 = new byte[0];
    private final List<YangInstanceIdentifier.NodeIdentifier> codedNodeIdentifiers = new ArrayList<YangInstanceIdentifier.NodeIdentifier>();
    private final List<QNameModule> codedModules = new ArrayList<QNameModule>();
    private final List<String> codedStrings = new ArrayList<String>();

    PotassiumDataInput(DataInput input) {
        super(input);
    }

    @Override
    public NormalizedNodeStreamVersion getVersion() {
        return NormalizedNodeStreamVersion.POTASSIUM;
    }

    @Override
    public void streamNormalizedNode(NormalizedNodeStreamWriter writer) throws IOException {
        this.streamNormalizedNode(Objects.requireNonNull(writer), null, this.input.readByte());
    }

    private void streamNormalizedNode(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.PathArgument parent, byte nodeHeader) throws IOException {
        switch (nodeHeader & 0xF) {
            case 1: {
                this.streamLeaf(writer, parent, nodeHeader);
                break;
            }
            case 2: {
                this.streamContainer(writer, nodeHeader);
                break;
            }
            case 3: {
                this.streamList(writer, nodeHeader);
                break;
            }
            case 4: {
                this.streamMap(writer, nodeHeader);
                break;
            }
            case 5: {
                this.streamMapOrdered(writer, nodeHeader);
                break;
            }
            case 6: {
                this.streamLeafset(writer, nodeHeader);
                break;
            }
            case 7: {
                this.streamLeafsetOrdered(writer, nodeHeader);
                break;
            }
            case 8: {
                this.streamChoice(writer, nodeHeader);
                break;
            }
            case 12: {
                this.streamAnyxml(writer, nodeHeader);
                break;
            }
            case 9: {
                this.streamListEntry(writer, parent, nodeHeader);
                break;
            }
            case 10: {
                this.streamLeafsetEntry(writer, parent, nodeHeader);
                break;
            }
            case 11: {
                this.streamMapEntry(writer, parent, nodeHeader);
                break;
            }
            default: {
                throw new InvalidNormalizedNodeStreamException("Unexpected node header " + nodeHeader);
            }
        }
    }

    private void streamAnyxml(NormalizedNodeStreamWriter writer, byte nodeHeader) throws IOException {
        YangInstanceIdentifier.NodeIdentifier identifier = this.decodeNodeIdentifier(nodeHeader);
        LOG.trace("Streaming anyxml node {}", (Object)identifier);
        DOMSource value = this.readDOMSource();
        if (writer.startAnyxmlNode(identifier, DOMSource.class)) {
            writer.domSourceValue(value);
            writer.endNode();
        }
    }

    private void streamChoice(NormalizedNodeStreamWriter writer, byte nodeHeader) throws IOException {
        YangInstanceIdentifier.NodeIdentifier identifier = this.decodeNodeIdentifier(nodeHeader);
        LOG.trace("Streaming choice node {}", (Object)identifier);
        writer.startChoiceNode(identifier, -1);
        this.commonStreamContainer(writer, (YangInstanceIdentifier.PathArgument)identifier);
    }

    private void streamContainer(NormalizedNodeStreamWriter writer, byte nodeHeader) throws IOException {
        YangInstanceIdentifier.NodeIdentifier identifier = this.decodeNodeIdentifier(nodeHeader);
        LOG.trace("Streaming container node {}", (Object)identifier);
        writer.startContainerNode(identifier, -1);
        this.commonStreamContainer(writer, (YangInstanceIdentifier.PathArgument)identifier);
    }

    private void streamLeaf(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.PathArgument parent, byte nodeHeader) throws IOException {
        Object value;
        YangInstanceIdentifier.NodeIdentifier identifier = this.decodeNodeIdentifier(nodeHeader);
        LOG.trace("Streaming leaf node {}", (Object)identifier);
        writer.startLeafNode(identifier);
        if ((nodeHeader & 0x40) == 64) {
            if (!(parent instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates)) {
                throw new InvalidNormalizedNodeStreamException("Invalid predicate leaf " + identifier + " in parent " + parent);
            }
            YangInstanceIdentifier.NodeIdentifierWithPredicates nip = (YangInstanceIdentifier.NodeIdentifierWithPredicates)parent;
            value = nip.getValue(identifier.getNodeType());
            if (value == null) {
                throw new InvalidNormalizedNodeStreamException("Failed to find predicate leaf " + identifier + " in parent " + parent);
            }
        } else {
            value = this.readLeafValue();
        }
        writer.scalarValue(value);
        writer.endNode();
    }

    private void streamLeafset(NormalizedNodeStreamWriter writer, byte nodeHeader) throws IOException {
        YangInstanceIdentifier.NodeIdentifier identifier = this.decodeNodeIdentifier(nodeHeader);
        LOG.trace("Streaming leaf set node {}", (Object)identifier);
        writer.startLeafSet(identifier, -1);
        this.commonStreamContainer(writer, (YangInstanceIdentifier.PathArgument)identifier);
    }

    private void streamLeafsetOrdered(NormalizedNodeStreamWriter writer, byte nodeHeader) throws IOException {
        YangInstanceIdentifier.NodeIdentifier identifier = this.decodeNodeIdentifier(nodeHeader);
        LOG.trace("Streaming ordered leaf set node {}", (Object)identifier);
        writer.startOrderedLeafSet(identifier, -1);
        this.commonStreamContainer(writer, (YangInstanceIdentifier.PathArgument)identifier);
    }

    private void streamLeafsetEntry(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.PathArgument parent, byte nodeHeader) throws IOException {
        YangInstanceIdentifier.NodeIdentifier nodeId = this.decodeNodeIdentifier(nodeHeader, parent);
        Object value = this.readLeafValue();
        YangInstanceIdentifier.NodeWithValue leafIdentifier = new YangInstanceIdentifier.NodeWithValue(nodeId.getNodeType(), value);
        LOG.trace("Streaming leaf set entry node {}", (Object)leafIdentifier);
        writer.startLeafSetEntryNode(leafIdentifier);
        writer.scalarValue(value);
        writer.endNode();
    }

    private void streamList(NormalizedNodeStreamWriter writer, byte nodeHeader) throws IOException {
        YangInstanceIdentifier.NodeIdentifier identifier = this.decodeNodeIdentifier(nodeHeader);
        writer.startUnkeyedList(identifier, -1);
        this.commonStreamContainer(writer, (YangInstanceIdentifier.PathArgument)identifier);
    }

    private void streamListEntry(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.PathArgument parent, byte nodeHeader) throws IOException {
        YangInstanceIdentifier.NodeIdentifier identifier = this.decodeNodeIdentifier(nodeHeader, parent);
        LOG.trace("Streaming unkeyed list item node {}", (Object)identifier);
        writer.startUnkeyedListItem(identifier, -1);
        this.commonStreamContainer(writer, (YangInstanceIdentifier.PathArgument)identifier);
    }

    private void streamMap(NormalizedNodeStreamWriter writer, byte nodeHeader) throws IOException {
        YangInstanceIdentifier.NodeIdentifier identifier = this.decodeNodeIdentifier(nodeHeader);
        LOG.trace("Streaming map node {}", (Object)identifier);
        writer.startMapNode(identifier, -1);
        this.commonStreamContainer(writer, (YangInstanceIdentifier.PathArgument)identifier);
    }

    private void streamMapOrdered(NormalizedNodeStreamWriter writer, byte nodeHeader) throws IOException {
        YangInstanceIdentifier.NodeIdentifier identifier = this.decodeNodeIdentifier(nodeHeader);
        LOG.trace("Streaming ordered map node {}", (Object)identifier);
        writer.startOrderedMapNode(identifier, -1);
        this.commonStreamContainer(writer, (YangInstanceIdentifier.PathArgument)identifier);
    }

    private void streamMapEntry(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.PathArgument parent, byte nodeHeader) throws IOException {
        YangInstanceIdentifier.NodeIdentifier nodeId = this.decodeNodeIdentifier(nodeHeader, parent);
        int size = switch (PotassiumDataInput.mask(nodeHeader, (byte)-64)) {
            case 0 -> 0;
            case 64 -> 1;
            case -128 -> this.input.readUnsignedByte();
            case -64 -> this.input.readInt();
            default -> throw new IllegalStateException("Failed to decode NodeIdentifierWithPredicates size from header " + nodeHeader);
        };
        YangInstanceIdentifier.NodeIdentifierWithPredicates identifier = this.readNodeIdentifierWithPredicates(nodeId.getNodeType(), size);
        LOG.trace("Streaming map entry node {}", (Object)identifier);
        writer.startMapEntryNode(identifier, -1);
        this.commonStreamContainer(writer, (YangInstanceIdentifier.PathArgument)identifier);
    }

    private void commonStreamContainer(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.PathArgument parent) throws IOException {
        byte nodeType = this.input.readByte();
        while (nodeType != 0) {
            this.streamNormalizedNode(writer, parent, nodeType);
            nodeType = this.input.readByte();
        }
        writer.endNode();
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier decodeNodeIdentifier() throws IOException {
        YangInstanceIdentifier.NodeIdentifier nodeId;
        QNameModule module = this.decodeQNameModule();
        String localName = this.readRefString();
        try {
            nodeId = QNameFactory.getNodeIdentifier(module, localName);
        }
        catch (ExecutionException e) {
            throw new InvalidNormalizedNodeStreamException("Illegal QName module=" + module + " localName=" + localName, e);
        }
        this.codedNodeIdentifiers.add(nodeId);
        return nodeId;
    }

    private YangInstanceIdentifier.NodeIdentifier decodeNodeIdentifier(byte nodeHeader) throws IOException {
        return this.decodeNodeIdentifier(nodeHeader, null);
    }

    private YangInstanceIdentifier.NodeIdentifier decodeNodeIdentifier(byte nodeHeader, YangInstanceIdentifier.PathArgument parent) throws IOException {
        int index;
        switch (nodeHeader & 0x30) {
            case 16: {
                return this.readNodeIdentifier();
            }
            case 32: {
                index = this.input.readUnsignedByte();
                break;
            }
            case 48: {
                index = this.input.readInt();
                break;
            }
            case 0: {
                if (parent instanceof YangInstanceIdentifier.NodeIdentifier) {
                    YangInstanceIdentifier.NodeIdentifier nid = (YangInstanceIdentifier.NodeIdentifier)parent;
                    return nid;
                }
                throw new InvalidNormalizedNodeStreamException("Invalid node identifier reference to parent " + parent);
            }
            default: {
                throw new InvalidNormalizedNodeStreamException("Unexpected node identifier addressing in header " + nodeHeader);
            }
        }
        try {
            return this.codedNodeIdentifiers.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidNormalizedNodeStreamException("Invalid QName reference " + index, e);
        }
    }

    @Override
    public YangInstanceIdentifier readYangInstanceIdentifier() throws IOException {
        byte type = this.input.readByte();
        if (type == 21) {
            return this.readYangInstanceIdentifier(this.input.readInt());
        }
        if (type >= 96) {
            return this.readYangInstanceIdentifier(type - 96);
        }
        throw new InvalidNormalizedNodeStreamException("Unexpected YangInstanceIdentifier type " + type);
    }

    private @NonNull YangInstanceIdentifier readYangInstanceIdentifier(int size) throws IOException {
        if (size > 0) {
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)size);
            for (int i = 0; i < size; ++i) {
                builder.add((Object)this.readPathArgument());
            }
            return YangInstanceIdentifier.of((ImmutableList)builder.build());
        }
        if (size == 0) {
            return YangInstanceIdentifier.of();
        }
        throw new InvalidNormalizedNodeStreamException("Invalid YangInstanceIdentifier size " + size);
    }

    public QName readQName() throws IOException {
        byte type = this.input.readByte();
        return switch (type) {
            case 22 -> this.decodeQName();
            case 23 -> this.decodeQNameRef1();
            case 24 -> this.decodeQNameRef2();
            case 25 -> this.decodeQNameRef4();
            default -> throw new InvalidNormalizedNodeStreamException("Unexpected QName type " + type);
        };
    }

    @Override
    public YangInstanceIdentifier.PathArgument readPathArgument() throws IOException {
        byte header = this.input.readByte();
        return switch (header & 3) {
            case 1 -> {
                PotassiumDataInput.verifyPathIdentifierOnly(header);
                yield this.readNodeIdentifier(header);
            }
            case 2 -> this.readNodeIdentifierWithPredicates(header);
            case 3 -> {
                PotassiumDataInput.verifyPathIdentifierOnly(header);
                yield this.readNodeWithValue(header);
            }
            default -> throw new InvalidNormalizedNodeStreamException("Unexpected PathArgument header " + header);
        };
    }

    @Override
    @Deprecated(since="11.0.0", forRemoval=true)
    public Either<YangInstanceIdentifier.PathArgument, LegacyPathArgument> readLegacyPathArgument() throws IOException {
        return Either.ofFirst((Object)this.readPathArgument());
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier readNodeIdentifier() throws IOException {
        return this.decodeNodeIdentifier();
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier readNodeIdentifier(byte header) throws IOException {
        return switch (header & 0xC) {
            case 0 -> this.decodeNodeIdentifier();
            case 4 -> this.decodeNodeIdentifierRef1();
            case 8 -> this.decodeNodeIdentifierRef2();
            case 12 -> this.decodeNodeIdentifierRef4();
            default -> throw new InvalidNormalizedNodeStreamException("Invalid QName coding in " + header);
        };
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifierWithPredicates readNodeIdentifierWithPredicates(byte header) throws IOException {
        QName qname = this.readNodeIdentifier(header).getNodeType();
        return switch (PotassiumDataInput.mask(header, (byte)-16)) {
            case -96 -> this.readNodeIdentifierWithPredicates(qname, this.input.readUnsignedByte());
            case -64 -> this.readNodeIdentifierWithPredicates(qname, this.input.readUnsignedShort());
            case -32 -> this.readNodeIdentifierWithPredicates(qname, this.input.readInt());
            default -> this.readNodeIdentifierWithPredicates(qname, PotassiumDataInput.rshift(header, (byte)4));
        };
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifierWithPredicates readNodeIdentifierWithPredicates(QName qname, int size) throws IOException {
        if (size == 1) {
            return YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)qname, (QName)this.readQName(), (Object)this.readLeafValue());
        }
        if (size > 1) {
            ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)size);
            for (int i = 0; i < size; ++i) {
                builder.put((Object)this.readQName(), this.readLeafValue());
            }
            return YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)qname, (Map)builder.build());
        }
        if (size == 0) {
            return YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)qname);
        }
        throw new InvalidNormalizedNodeStreamException("Invalid predicate count " + size);
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeWithValue<?> readNodeWithValue(byte header) throws IOException {
        QName qname = this.readNodeIdentifier(header).getNodeType();
        return new YangInstanceIdentifier.NodeWithValue(qname, this.readLeafValue());
    }

    private static void verifyPathIdentifierOnly(byte header) throws InvalidNormalizedNodeStreamException {
        if (PotassiumDataInput.mask(header, (byte)-16) != 0) {
            throw new InvalidNormalizedNodeStreamException("Invalid path argument header " + header);
        }
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier decodeNodeIdentifierRef1() throws IOException {
        return this.lookupNodeIdentifier(this.input.readUnsignedByte());
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier decodeNodeIdentifierRef2() throws IOException {
        return this.lookupNodeIdentifier(this.input.readUnsignedShort() + 256);
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier decodeNodeIdentifierRef4() throws IOException {
        return this.lookupNodeIdentifier(this.input.readInt());
    }

    private @NonNull QName decodeQName() throws IOException {
        return this.decodeNodeIdentifier().getNodeType();
    }

    private @NonNull QName decodeQNameRef1() throws IOException {
        return this.lookupQName(this.input.readUnsignedByte());
    }

    private @NonNull QName decodeQNameRef2() throws IOException {
        return this.lookupQName(this.input.readUnsignedShort() + 256);
    }

    private @NonNull QName decodeQNameRef4() throws IOException {
        return this.lookupQName(this.input.readInt());
    }

    private @NonNull QNameModule decodeQNameModule() throws IOException {
        int index;
        byte type = this.input.readByte();
        switch (type) {
            case 26: {
                index = this.input.readUnsignedByte();
                break;
            }
            case 27: {
                index = this.input.readUnsignedShort() + 256;
                break;
            }
            case 28: {
                index = this.input.readInt();
                break;
            }
            default: {
                return this.decodeQNameModuleDef(type);
            }
        }
        try {
            return this.codedModules.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidNormalizedNodeStreamException("Invalid QNameModule reference " + index, e);
        }
    }

    private @NonNull QNameModule decodeQNameModuleDef(byte type) throws IOException {
        QNameModule module;
        String namespace = this.readRefString(type);
        byte refType = this.input.readByte();
        String revision = refType == 40 ? null : this.readRefString(refType);
        try {
            module = QNameFactory.createModule(namespace, revision);
        }
        catch (UncheckedExecutionException e) {
            throw new InvalidNormalizedNodeStreamException("Illegal QNameModule ns=" + namespace + " rev=" + revision, e);
        }
        this.codedModules.add(module);
        return module;
    }

    private @NonNull String readRefString() throws IOException {
        return this.readRefString(this.input.readByte());
    }

    private @NonNull String readRefString(byte type) throws IOException {
        String str;
        switch (type) {
            case 15: {
                return this.lookupString(this.input.readUnsignedByte());
            }
            case 16: {
                return this.lookupString(this.input.readUnsignedShort() + 256);
            }
            case 17: {
                return this.lookupString(this.input.readInt());
            }
            case 40: {
                return "";
            }
            case 12: {
                str = this.readString2();
                break;
            }
            case 13: {
                str = this.readString4();
                break;
            }
            case 14: {
                str = this.readCharsString();
                break;
            }
            case 11: {
                str = this.input.readUTF();
                break;
            }
            default: {
                throw new InvalidNormalizedNodeStreamException("Unexpected String type " + type);
            }
        }
        this.codedStrings.add((String)Verify.verifyNotNull((Object)str));
        return str;
    }

    private @NonNull String readString() throws IOException {
        byte type = this.input.readByte();
        return switch (type) {
            case 40 -> "";
            case 11 -> this.input.readUTF();
            case 12 -> this.readString2();
            case 13 -> this.readString4();
            case 14 -> this.readCharsString();
            default -> throw new InvalidNormalizedNodeStreamException("Unexpected String type " + type);
        };
    }

    private @NonNull String readString2() throws IOException {
        return this.readByteString(this.input.readUnsignedShort());
    }

    private @NonNull String readString4() throws IOException {
        return this.readByteString(this.input.readInt());
    }

    private @NonNull String readByteString(int size) throws IOException {
        if (size > 0) {
            byte[] bytes = new byte[size];
            this.input.readFully(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        if (size == 0) {
            return "";
        }
        throw new InvalidNormalizedNodeStreamException("Invalid String bytes length " + size);
    }

    private @NonNull String readCharsString() throws IOException {
        int size = this.input.readInt();
        if (size > 0) {
            char[] chars = new char[size];
            for (int i = 0; i < size; ++i) {
                chars[i] = this.input.readChar();
            }
            return String.valueOf(chars);
        }
        if (size == 0) {
            return "";
        }
        throw new InvalidNormalizedNodeStreamException("Invalid String chars length " + size);
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier lookupNodeIdentifier(int index) throws InvalidNormalizedNodeStreamException {
        try {
            return this.codedNodeIdentifiers.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidNormalizedNodeStreamException("Invalid QName reference " + index, e);
        }
    }

    private @NonNull QName lookupQName(int index) throws InvalidNormalizedNodeStreamException {
        return this.lookupNodeIdentifier(index).getNodeType();
    }

    private @NonNull String lookupString(int index) throws InvalidNormalizedNodeStreamException {
        try {
            return this.codedStrings.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidNormalizedNodeStreamException("Invalid String reference " + index, e);
        }
    }

    private @NonNull DOMSource readDOMSource() throws IOException {
        String str = this.readString();
        try {
            return new DOMSource(UntrustedXML.newDocumentBuilder().parse(new InputSource(new StringReader(str))).getDocumentElement());
        }
        catch (SAXException e) {
            throw new IOException("Error parsing XML: " + str, e);
        }
    }

    private @NonNull Object readLeafValue() throws IOException {
        byte type = this.input.readByte();
        switch (type) {
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
            case 2: {
                return Empty.value();
            }
            case 3: {
                return this.input.readByte();
            }
            case 32: {
                return INT8_0;
            }
            case 4: {
                return this.input.readShort();
            }
            case 33: {
                return INT16_0;
            }
            case 5: {
                return this.input.readInt();
            }
            case 34: {
                return INT32_0;
            }
            case 41: {
                return this.input.readShort() & 0xFFFF;
            }
            case 6: {
                return this.input.readLong();
            }
            case 35: {
                return INT64_0;
            }
            case 43: {
                return (long)this.input.readInt() & 0xFFFFFFFFL;
            }
            case 7: {
                return Uint8.fromByteBits((byte)this.input.readByte());
            }
            case 36: {
                return Uint8.ZERO;
            }
            case 8: {
                return Uint16.fromShortBits((short)this.input.readShort());
            }
            case 37: {
                return Uint16.ZERO;
            }
            case 9: {
                return Uint32.fromIntBits((int)this.input.readInt());
            }
            case 38: {
                return Uint32.ZERO;
            }
            case 42: {
                return Uint32.fromIntBits((int)(this.input.readShort() & 0xFFFF));
            }
            case 10: {
                return Uint64.fromLongBits((long)this.input.readLong());
            }
            case 39: {
                return Uint64.ZERO;
            }
            case 44: {
                return Uint64.fromLongBits((long)((long)this.input.readInt() & 0xFFFFFFFFL));
            }
            case 29: {
                return Decimal64.of((int)this.input.readByte(), (long)WritableObjects.readLong((DataInput)this.input));
            }
            case 40: {
                return "";
            }
            case 11: {
                return this.input.readUTF();
            }
            case 12: {
                return this.readString2();
            }
            case 13: {
                return this.readString4();
            }
            case 14: {
                return this.readCharsString();
            }
            case -128: {
                return BINARY_0;
            }
            case 18: {
                return this.readBinary(128 + this.input.readUnsignedByte());
            }
            case 19: {
                return this.readBinary(384 + this.input.readUnsignedShort());
            }
            case 20: {
                return this.readBinary(this.input.readInt());
            }
            case 96: {
                return YangInstanceIdentifier.of();
            }
            case 21: {
                return this.readYangInstanceIdentifier(this.input.readInt());
            }
            case 22: {
                return this.decodeQName();
            }
            case 23: {
                return this.decodeQNameRef1();
            }
            case 24: {
                return this.decodeQNameRef2();
            }
            case 25: {
                return this.decodeQNameRef4();
            }
            case 64: {
                return ImmutableSet.of();
            }
            case 93: {
                return this.readBits(this.input.readUnsignedByte() + 29);
            }
            case 94: {
                return this.readBits(this.input.readUnsignedShort() + 285);
            }
            case 95: {
                return this.readBits(this.input.readInt());
            }
        }
        if (type > -128 && type <= -1) {
            return this.readBinary(type - -128);
        }
        if (type > 64 && type < 93) {
            return this.readBits(type - 64);
        }
        if (type > 96) {
            return this.readYangInstanceIdentifier(type - 96);
        }
        throw new InvalidNormalizedNodeStreamException("Invalid value type " + type);
    }

    private byte @NonNull [] readBinary(int size) throws IOException {
        if (size > 0) {
            byte[] ret = new byte[size];
            this.input.readFully(ret);
            return ret;
        }
        if (size == 0) {
            return BINARY_0;
        }
        throw new InvalidNormalizedNodeStreamException("Invalid binary length " + size);
    }

    private @NonNull ImmutableSet<String> readBits(int size) throws IOException {
        if (size > 0) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (int i = 0; i < size; ++i) {
                builder.add((Object)this.readRefString());
            }
            return builder.build();
        }
        if (size == 0) {
            return ImmutableSet.of();
        }
        throw new InvalidNormalizedNodeStreamException("Invalid bits length " + size);
    }

    private static byte mask(byte header, byte mask) {
        return (byte)(header & mask);
    }

    private static int rshift(byte header, byte shift) {
        return (header & 0xFF) >>> shift;
    }
}

