/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import java.util.Objects;
import org.opendaylight.yangtools.yang.data.codec.gson.BooleanJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.NumberJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.QuotedJSONCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.DataStringCodec;

abstract sealed class AbstractJSONCodec<T>
implements JSONCodec<T>
permits BooleanJSONCodec, NumberJSONCodec, QuotedJSONCodec {
    private final DataStringCodec<T> codec;

    AbstractJSONCodec(DataStringCodec<T> codec) {
        this.codec = Objects.requireNonNull(codec);
    }

    public final Class<T> getDataType() {
        return this.codec.getInputClass();
    }

    @Override
    public final T parseValue(String str) {
        return (T)this.codec.deserialize((Object)str);
    }

    final String serialize(T input) {
        return (String)this.codec.serialize(input);
    }
}

