/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONValue;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONValueWriter;
import org.opendaylight.yangtools.yang.data.util.AbstractStringInstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.LeafrefResolver;

abstract sealed class InstanceIdentifierJSONCodec
extends AbstractStringInstanceIdentifierCodec
implements JSONCodec<YangInstanceIdentifier> {
    private final @NonNull DataSchemaContextTree dataContextTree;
    private final JSONCodecFactory codecFactory;
    private final EffectiveModelContext context;

    InstanceIdentifierJSONCodec(EffectiveModelContext context, JSONCodecFactory jsonCodecFactory) {
        this.context = Objects.requireNonNull(context);
        this.dataContextTree = DataSchemaContextTree.from((EffectiveModelContext)context);
        this.codecFactory = Objects.requireNonNull(jsonCodecFactory);
    }

    protected final QNameModule moduleForPrefix(String prefix) {
        Iterator modules = this.context.findModuleStatements(prefix).iterator();
        return modules.hasNext() ? ((ModuleEffectiveStatement)modules.next()).localQNameModule() : null;
    }

    protected final String prefixForNamespace(XMLNamespace namespace) {
        Iterator modules = this.context.findModuleStatements(namespace).iterator();
        return modules.hasNext() ? ((UnresolvedQName.Unqualified)((ModuleEffectiveStatement)modules.next()).argument()).getLocalName() : null;
    }

    protected final DataSchemaContextTree getDataContextTree() {
        return this.dataContextTree;
    }

    protected final Object deserializeKeyValue(DataSchemaNode schemaNode, LeafrefResolver resolver, String value) {
        DataSchemaNode dataSchemaNode = schemaNode;
        Objects.requireNonNull(dataSchemaNode);
        DataSchemaNode dataSchemaNode2 = dataSchemaNode;
        int n = 0;
        JSONCodec codec = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LeafSchemaNode.class, LeafListSchemaNode.class}, (Object)dataSchemaNode2, n)) {
            case 0 -> {
                LeafSchemaNode leaf = (LeafSchemaNode)dataSchemaNode2;
                yield (JSONCodec)this.codecFactory.codecFor((TypeAware)leaf, resolver);
            }
            case 1 -> {
                LeafListSchemaNode leafList = (LeafListSchemaNode)dataSchemaNode2;
                yield (JSONCodec)this.codecFactory.codecFor((TypeAware)leafList, resolver);
            }
            default -> throw new IllegalArgumentException("schemaNode " + String.valueOf(schemaNode) + " must be of type LeafSchemaNode or LeafListSchemaNode");
        };
        return codec.parseValue(value);
    }

    public final Class<YangInstanceIdentifier> getDataType() {
        return YangInstanceIdentifier.class;
    }

    @Override
    public final YangInstanceIdentifier parseValue(String str) {
        return (YangInstanceIdentifier)this.deserialize(str);
    }

    @Override
    public JSONValue unparseValue(YangInstanceIdentifier value) {
        return new JSONValue((String)this.serialize(value), JSONValue.Kind.STRING);
    }

    @Override
    public final void writeValue(JSONValueWriter ctx, YangInstanceIdentifier value) throws IOException {
        String str;
        try {
            str = (String)this.serialize(value);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Failed to encode instance-identifier", e);
        }
        ctx.writeString(str);
    }

    static final class RFC7951
    extends InstanceIdentifierJSONCodec {
        RFC7951(EffectiveModelContext context, JSONCodecFactory jsonCodecFactory) {
            super(context, jsonCodecFactory);
        }

        protected StringBuilder appendQName(StringBuilder sb, QName qname, QNameModule lastModule) {
            return qname.getModule().equals((Object)lastModule) ? sb.append(qname.getLocalName()) : super.appendQName(sb, qname, lastModule);
        }

        protected QName createQName(QNameModule lastModule, String localName) {
            Preconditions.checkArgument((lastModule != null ? 1 : 0) != 0, (String)"Unprefixed leading name %s", (Object)localName);
            return QName.create((QNameModule)lastModule, (String)localName);
        }
    }

    static final class Lhotka02
    extends InstanceIdentifierJSONCodec {
        Lhotka02(EffectiveModelContext context, JSONCodecFactory jsonCodecFactory) {
            super(context, jsonCodecFactory);
        }
    }
}

