/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.MalformedJsonException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.Flushable;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataSchemaNode;
import org.opendaylight.yangtools.util.xml.UntrustedXML;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.util.AbstractNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.AnyXmlNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.CompositeNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.LeafListNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.LeafNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ListNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.MultipleEntryDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ParserStreamUtils;
import org.opendaylight.yangtools.yang.data.util.SimpleNodeDataWithSchema;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.OperationDefinition;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.LeafrefResolver;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public final class JsonParserStream
implements Closeable,
Flushable {
    static final String ANYXML_ARRAY_ELEMENT_ID = "array-element";
    private static final Logger LOG = LoggerFactory.getLogger(JsonParserStream.class);
    private final Deque<XMLNamespace> namespaces = new ArrayDeque<XMLNamespace>();
    private final NormalizedNodeStreamWriter writer;
    private final JSONCodecFactory codecs;
    private final DataSchemaNode parentNode;
    private final SchemaInferenceStack stack;
    private final boolean lenient;

    private JsonParserStream(NormalizedNodeStreamWriter writer, JSONCodecFactory codecs, SchemaInferenceStack stack, boolean lenient) {
        this.writer = Objects.requireNonNull(writer);
        this.codecs = Objects.requireNonNull(codecs);
        this.stack = Objects.requireNonNull(stack);
        this.lenient = lenient;
        if (!stack.isEmpty()) {
            EffectiveStatement parent;
            EffectiveStatement effectiveStatement = parent = stack.currentStatement();
            Objects.requireNonNull(effectiveStatement);
            EffectiveStatement effectiveStatement2 = effectiveStatement;
            int n = 0;
            this.parentNode = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataSchemaNode.class, OperationDefinition.class, NotificationDefinition.class, YangDataSchemaNode.class}, (Object)effectiveStatement2, n)) {
                case 0 -> {
                    DataSchemaNode data;
                    yield data = (DataSchemaNode)effectiveStatement2;
                }
                case 1 -> {
                    OperationDefinition oper = (OperationDefinition)effectiveStatement2;
                    yield oper.toContainerLike();
                }
                case 2 -> {
                    NotificationDefinition notif = (NotificationDefinition)effectiveStatement2;
                    yield notif.toContainerLike();
                }
                case 3 -> {
                    YangDataSchemaNode yangData = (YangDataSchemaNode)effectiveStatement2;
                    yield yangData.toContainerLike();
                }
                default -> throw new IllegalArgumentException("Illegal parent node " + String.valueOf(parent));
            };
        } else {
            this.parentNode = stack.modelContext();
        }
    }

    public static @NonNull JsonParserStream create(@NonNull NormalizedNodeStreamWriter writer, @NonNull JSONCodecFactory codecFactory) {
        return new JsonParserStream(writer, codecFactory, SchemaInferenceStack.of((EffectiveModelContext)codecFactory.modelContext()), false);
    }

    public static @NonNull JsonParserStream create(@NonNull NormalizedNodeStreamWriter writer, @NonNull JSONCodecFactory codecFactory, @NonNull EffectiveStatementInference parentNode) {
        return new JsonParserStream(writer, codecFactory, SchemaInferenceStack.ofInference((EffectiveStatementInference)parentNode), false);
    }

    public static @NonNull JsonParserStream createLenient(@NonNull NormalizedNodeStreamWriter writer, @NonNull JSONCodecFactory codecFactory) {
        return new JsonParserStream(writer, codecFactory, SchemaInferenceStack.of((EffectiveModelContext)codecFactory.modelContext()), true);
    }

    public static @NonNull JsonParserStream createLenient(@NonNull NormalizedNodeStreamWriter writer, @NonNull JSONCodecFactory codecFactory, @NonNull EffectiveStatementInference parentNode) {
        return new JsonParserStream(writer, codecFactory, SchemaInferenceStack.ofInference((EffectiveStatementInference)parentNode), true);
    }

    public JsonParserStream parse(JsonReader reader) {
        boolean readerLenient = reader.isLenient();
        reader.setLenient(true);
        boolean isEmpty = true;
        try {
            reader.peek();
            isEmpty = false;
            CompositeNodeDataWithSchema compositeNodeDataWithSchema = new CompositeNodeDataWithSchema(this.parentNode);
            this.read(reader, (AbstractNodeDataWithSchema<?>)compositeNodeDataWithSchema);
            compositeNodeDataWithSchema.write(this.writer);
            JsonParserStream jsonParserStream = this;
            return jsonParserStream;
        }
        catch (EOFException e) {
            if (isEmpty) {
                JsonParserStream jsonParserStream = this;
                return jsonParserStream;
            }
            throw new JsonSyntaxException((Throwable)e);
        }
        catch (MalformedJsonException | NumberFormatException e) {
            throw new JsonSyntaxException(e);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
        catch (OutOfMemoryError | StackOverflowError e) {
            throw new JsonParseException("Failed parsing JSON source: " + String.valueOf(reader) + " to Json", (Throwable)e);
        }
        finally {
            reader.setLenient(readerLenient);
        }
    }

    private void traverseAnyXmlValue(JsonReader in, Document doc, Element parentElement) throws IOException {
        switch (in.peek()) {
            case STRING: 
            case NUMBER: {
                Text textNode = doc.createTextNode(in.nextString());
                parentElement.appendChild(textNode);
                break;
            }
            case BOOLEAN: {
                Text textNode = doc.createTextNode(Boolean.toString(in.nextBoolean()));
                parentElement.appendChild(textNode);
                break;
            }
            case NULL: {
                in.nextNull();
                Text textNode = doc.createTextNode("null");
                parentElement.appendChild(textNode);
                break;
            }
            case BEGIN_ARRAY: {
                in.beginArray();
                while (in.hasNext()) {
                    Element childElement = doc.createElement(ANYXML_ARRAY_ELEMENT_ID);
                    parentElement.appendChild(childElement);
                    this.traverseAnyXmlValue(in, doc, childElement);
                }
                in.endArray();
                break;
            }
            case BEGIN_OBJECT: {
                in.beginObject();
                while (in.hasNext()) {
                    Element childElement = doc.createElement(in.nextName());
                    parentElement.appendChild(childElement);
                    this.traverseAnyXmlValue(in, doc, childElement);
                }
                in.endObject();
                break;
            }
        }
    }

    private void readAnyXmlValue(JsonReader in, AnyXmlNodeDataWithSchema parent, String anyXmlObjectName) throws IOException {
        Document doc = UntrustedXML.newDocumentBuilder().newDocument();
        Element rootElement = doc.createElementNS(this.getCurrentNamespace().toString(), anyXmlObjectName);
        doc.appendChild(rootElement);
        this.traverseAnyXmlValue(in, doc, rootElement);
        parent.setValue((Object)new DOMSource(doc.getDocumentElement()));
    }

    private void read(JsonReader in, AbstractNodeDataWithSchema<?> parent) throws IOException {
        switch (in.peek()) {
            case STRING: 
            case NUMBER: {
                this.setValue(parent, in.nextString());
                break;
            }
            case BOOLEAN: {
                this.setValue(parent, Boolean.toString(in.nextBoolean()));
                break;
            }
            case NULL: {
                in.nextNull();
                this.setValue(parent, null);
                break;
            }
            case BEGIN_ARRAY: {
                in.beginArray();
                while (in.hasNext()) {
                    if (parent instanceof LeafNodeDataWithSchema) {
                        this.read(in, parent);
                        continue;
                    }
                    this.read(in, JsonParserStream.newArrayEntry(parent));
                }
                in.endArray();
                return;
            }
            case BEGIN_OBJECT: {
                HashSet<String> namesakes = new HashSet<String>();
                in.beginObject();
                if (JsonParserStream.isArray(parent)) {
                    parent = JsonParserStream.newArrayEntry(parent);
                }
                while (in.hasNext()) {
                    String jsonElementName = in.nextName();
                    DataSchemaNode parentSchema = parent.getSchema();
                    Map.Entry<String, XMLNamespace> namespaceAndName = this.resolveNamespace(jsonElementName, parentSchema);
                    String localName = namespaceAndName.getKey();
                    XMLNamespace namespace = namespaceAndName.getValue();
                    if (this.lenient && (localName == null || namespace == null)) {
                        LOG.debug("Schema node with name {} was not found under {}", (Object)localName, (Object)parentSchema.getQName());
                        in.skipValue();
                        continue;
                    }
                    this.addNamespace(namespace);
                    if (!namesakes.add(jsonElementName)) {
                        throw new JsonSyntaxException("Duplicate name " + jsonElementName + " in JSON input.");
                    }
                    Deque childDataSchemaNodes = ParserStreamUtils.findSchemaNodeByNameAndNamespace((DataSchemaNode)parentSchema, (String)localName, (XMLNamespace)this.getCurrentNamespace());
                    if (childDataSchemaNodes.isEmpty()) {
                        throw new IllegalStateException("Schema for node with name %s and namespace %s does not exist at %s".formatted(localName, this.getCurrentNamespace(), parentSchema));
                    }
                    QName qname = ((DataSchemaNode)childDataSchemaNodes.peekLast()).getQName();
                    AbstractNodeDataWithSchema newChild = ((CompositeNodeDataWithSchema)parent).addChild(childDataSchemaNodes, CompositeNodeDataWithSchema.ChildReusePolicy.NOOP);
                    if (newChild instanceof AnyXmlNodeDataWithSchema) {
                        AnyXmlNodeDataWithSchema anyxml = (AnyXmlNodeDataWithSchema)newChild;
                        this.readAnyXmlValue(in, anyxml, jsonElementName);
                    } else {
                        this.stack.enterDataTree(qname);
                        this.read(in, newChild);
                        this.stack.exit();
                    }
                    this.removeNamespace();
                }
                in.endObject();
                return;
            }
        }
    }

    private static boolean isArray(AbstractNodeDataWithSchema<?> parent) {
        return parent instanceof ListNodeDataWithSchema || parent instanceof LeafListNodeDataWithSchema;
    }

    private static AbstractNodeDataWithSchema<?> newArrayEntry(AbstractNodeDataWithSchema<?> parent) {
        if (parent instanceof MultipleEntryDataWithSchema) {
            MultipleEntryDataWithSchema multiple = (MultipleEntryDataWithSchema)parent;
            return multiple.newChildEntry();
        }
        throw new IllegalStateException("Found an unexpected array nested under " + String.valueOf(parent.getSchema().getQName()));
    }

    private void setValue(AbstractNodeDataWithSchema<?> parent, String value) {
        if (!(parent instanceof SimpleNodeDataWithSchema)) {
            throw new IllegalArgumentException("Node " + String.valueOf(parent.getSchema().getQName()) + " is not a simple type");
        }
        SimpleNodeDataWithSchema parentSimpleNode = (SimpleNodeDataWithSchema)parent;
        Object prevValue = parentSimpleNode.getValue();
        if (prevValue != null) {
            throw new IllegalArgumentException("Node '%s' has already set its value to '%s'".formatted(parentSimpleNode.getSchema().getQName(), prevValue));
        }
        Object translatedValue = this.translateValueByType(value, parentSimpleNode.getSchema());
        parentSimpleNode.setValue(translatedValue);
    }

    private Object translateValueByType(String value, DataSchemaNode node) {
        if (node instanceof TypedDataSchemaNode) {
            TypedDataSchemaNode typedNode = (TypedDataSchemaNode)node;
            return ((JSONCodec)this.codecs.codecFor((TypeAware)typedNode, (LeafrefResolver)this.stack)).parseValue(value);
        }
        throw new IllegalArgumentException("Unexpected node " + String.valueOf(node));
    }

    private void removeNamespace() {
        this.namespaces.pop();
    }

    private void addNamespace(XMLNamespace namespace) {
        this.namespaces.push(namespace);
    }

    private Map.Entry<String, XMLNamespace> resolveNamespace(String childName, DataSchemaNode dataSchemaNode) {
        XMLNamespace namespace;
        String nodeNamePart;
        int lastIndexOfColon = childName.lastIndexOf(58);
        if (lastIndexOfColon != -1) {
            String moduleNamePart = childName.substring(0, lastIndexOfColon);
            nodeNamePart = childName.substring(lastIndexOfColon + 1);
            Iterator m = this.codecs.modelContext().findModuleStatements(moduleNamePart).iterator();
            namespace = m.hasNext() ? ((ModuleEffectiveStatement)m.next()).localQNameModule().namespace() : null;
        } else {
            nodeNamePart = childName;
            namespace = null;
        }
        if (namespace == null) {
            Set<XMLNamespace> potentialUris = this.resolveAllPotentialNamespaces(nodeNamePart, dataSchemaNode);
            if (potentialUris.contains(this.getCurrentNamespace())) {
                namespace = this.getCurrentNamespace();
            } else if (potentialUris.size() == 1) {
                namespace = potentialUris.iterator().next();
            } else {
                if (potentialUris.size() > 1) {
                    throw new IllegalStateException("Choose suitable module name for element " + nodeNamePart + ":" + this.toModuleNames(potentialUris));
                }
                if (potentialUris.isEmpty() && !this.lenient) {
                    throw new IllegalStateException("Schema node with name " + nodeNamePart + " was not found under " + String.valueOf(dataSchemaNode.getQName()) + ".");
                }
            }
        }
        return new AbstractMap.SimpleImmutableEntry<String, Object>(nodeNamePart, namespace);
    }

    private String toModuleNames(Set<XMLNamespace> potentialUris) {
        StringBuilder sb = new StringBuilder();
        for (XMLNamespace potentialUri : potentialUris) {
            sb.append('\n');
            sb.append(((UnresolvedQName.Unqualified)((ModuleEffectiveStatement)this.codecs.modelContext().findModuleStatements(potentialUri).iterator().next()).argument()).getLocalName());
        }
        return sb.toString();
    }

    private Set<XMLNamespace> resolveAllPotentialNamespaces(String elementName, DataSchemaNode dataSchemaNode) {
        HashSet<XMLNamespace> potentialUris = new HashSet<XMLNamespace>();
        HashSet<ChoiceSchemaNode> choices = new HashSet<ChoiceSchemaNode>();
        if (dataSchemaNode instanceof DataNodeContainer) {
            DataNodeContainer container = (DataNodeContainer)dataSchemaNode;
            for (DataSchemaNode childSchemaNode : container.getChildNodes()) {
                if (childSchemaNode instanceof ChoiceSchemaNode) {
                    ChoiceSchemaNode choice = (ChoiceSchemaNode)childSchemaNode;
                    choices.add(choice);
                    continue;
                }
                if (!childSchemaNode.getQName().getLocalName().equals(elementName)) continue;
                potentialUris.add(childSchemaNode.getQName().getNamespace());
            }
            for (ChoiceSchemaNode choiceNode : choices) {
                for (CaseSchemaNode concreteCase : choiceNode.getCases()) {
                    potentialUris.addAll(this.resolveAllPotentialNamespaces(elementName, (DataSchemaNode)concreteCase));
                }
            }
        }
        return potentialUris;
    }

    private XMLNamespace getCurrentNamespace() {
        return this.namespaces.peek();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }
}

