/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.xml.RandomPrefixInstanceIdentifierSerializer;
import org.opendaylight.yangtools.yang.data.codec.xml.ValueWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamWriterUtils;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextProvider;

final class SchemaAwareXMLStreamWriterUtils
extends XMLStreamWriterUtils
implements EffectiveModelContextProvider {
    private final @NonNull EffectiveModelContext schemaContext;

    SchemaAwareXMLStreamWriterUtils(EffectiveModelContext schemaContext) {
        this.schemaContext = Objects.requireNonNull(schemaContext);
    }

    @Override
    String encodeInstanceIdentifier(ValueWriter writer, YangInstanceIdentifier value) throws XMLStreamException {
        RandomPrefixInstanceIdentifierSerializer iiCodec = new RandomPrefixInstanceIdentifierSerializer(this.schemaContext, writer.getNamespaceContext());
        String serializedValue = (String)iiCodec.serialize(value);
        for (Map.Entry<XMLNamespace, String> e : iiCodec.getPrefixes()) {
            writer.writeNamespace(e.getValue(), e.getKey().toString());
        }
        return serializedValue;
    }

    public EffectiveModelContext getEffectiveModelContext() {
        return this.schemaContext;
    }
}

