/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedAnydata;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.DOMSourceAnydata;
import org.opendaylight.yangtools.yang.data.codec.xml.DOMSourceXMLStreamReader;
import org.opendaylight.yangtools.yang.data.codec.xml.PreferredPrefixes;
import org.opendaylight.yangtools.yang.data.codec.xml.SchemaAwareXMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.SchemalessXMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.StreamWriterFacade;
import org.opendaylight.yangtools.yang.data.codec.xml.ValueWriter;
import org.opendaylight.yangtools.yang.data.util.NormalizedNodeStreamWriterStack;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class XMLStreamNormalizedNodeStreamWriter<T>
implements NormalizedNodeStreamWriter,
NormalizedNodeStreamWriter.MetadataExtension {
    private static final Logger LOG = LoggerFactory.getLogger(XMLStreamNormalizedNodeStreamWriter.class);
    private static final Set<String> BROKEN_ATTRIBUTES = ConcurrentHashMap.newKeySet();
    private final @NonNull StreamWriterFacade facade;

    XMLStreamNormalizedNodeStreamWriter(XMLStreamWriter writer, @Nullable PreferredPrefixes pref) {
        this.facade = new StreamWriterFacade(writer, pref);
    }

    public static @NonNull NormalizedNodeStreamWriter create(XMLStreamWriter writer, EffectiveModelContext context) {
        return XMLStreamNormalizedNodeStreamWriter.create(writer, context, false);
    }

    public static @NonNull NormalizedNodeStreamWriter create(XMLStreamWriter writer, EffectiveModelContext context, boolean preferPrefixes) {
        return new SchemaAwareXMLStreamNormalizedNodeStreamWriter(writer, context, NormalizedNodeStreamWriterStack.of((EffectiveModelContext)context), preferPrefixes);
    }

    public static @NonNull NormalizedNodeStreamWriter create(XMLStreamWriter writer, EffectiveStatementInference inference) {
        return XMLStreamNormalizedNodeStreamWriter.create(writer, inference, false);
    }

    public static @NonNull NormalizedNodeStreamWriter create(XMLStreamWriter writer, EffectiveStatementInference inference, boolean preferPrefixes) {
        return new SchemaAwareXMLStreamNormalizedNodeStreamWriter(writer, inference.modelContext(), NormalizedNodeStreamWriterStack.of((EffectiveStatementInference)inference), preferPrefixes);
    }

    public static @NonNull NormalizedNodeStreamWriter create(XMLStreamWriter writer, EffectiveModelContext context, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable SchemaNodeIdentifier.Absolute path) {
        return XMLStreamNormalizedNodeStreamWriter.create(writer, context, path, false);
    }

    public static @NonNull NormalizedNodeStreamWriter create(XMLStreamWriter writer, EffectiveModelContext context, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable SchemaNodeIdentifier.Absolute path, boolean preferPrefixes) {
        return path == null ? XMLStreamNormalizedNodeStreamWriter.create(writer, context) : new SchemaAwareXMLStreamNormalizedNodeStreamWriter(writer, context, NormalizedNodeStreamWriterStack.of((EffectiveModelContext)context, (SchemaNodeIdentifier.Absolute)path), preferPrefixes);
    }

    public static @NonNull NormalizedNodeStreamWriter create(XMLStreamWriter writer, EffectiveModelContext context, YangInstanceIdentifier path) {
        return XMLStreamNormalizedNodeStreamWriter.create(writer, context, path, false);
    }

    public static @NonNull NormalizedNodeStreamWriter create(XMLStreamWriter writer, EffectiveModelContext context, YangInstanceIdentifier path, boolean preferPrefixes) {
        return new SchemaAwareXMLStreamNormalizedNodeStreamWriter(writer, context, NormalizedNodeStreamWriterStack.of((EffectiveModelContext)context, (YangInstanceIdentifier)path), preferPrefixes);
    }

    public static @NonNull NormalizedNodeStreamWriter forInputOf(XMLStreamWriter writer, EffectiveModelContext context, SchemaNodeIdentifier.Absolute operationPath) {
        return XMLStreamNormalizedNodeStreamWriter.forInputOf(writer, context, operationPath, false);
    }

    public static @NonNull NormalizedNodeStreamWriter forInputOf(XMLStreamWriter writer, EffectiveModelContext context, SchemaNodeIdentifier.Absolute operationPath, boolean preferPrefixes) {
        return XMLStreamNormalizedNodeStreamWriter.forOperation(writer, context, operationPath, YangConstants.operationInputQName((QNameModule)operationPath.lastNodeIdentifier().getModule()), preferPrefixes);
    }

    public static @NonNull NormalizedNodeStreamWriter forOutputOf(XMLStreamWriter writer, EffectiveModelContext context, SchemaNodeIdentifier.Absolute operationPath) {
        return XMLStreamNormalizedNodeStreamWriter.forOutputOf(writer, context, operationPath, false);
    }

    public static @NonNull NormalizedNodeStreamWriter forOutputOf(XMLStreamWriter writer, EffectiveModelContext context, SchemaNodeIdentifier.Absolute operationPath, boolean preferPrefixes) {
        return XMLStreamNormalizedNodeStreamWriter.forOperation(writer, context, operationPath, YangConstants.operationOutputQName((QNameModule)operationPath.lastNodeIdentifier().getModule()), preferPrefixes);
    }

    private static @NonNull NormalizedNodeStreamWriter forOperation(XMLStreamWriter writer, EffectiveModelContext context, SchemaNodeIdentifier.Absolute operationPath, QName qname, boolean preferPrefixes) {
        return new SchemaAwareXMLStreamNormalizedNodeStreamWriter(writer, context, NormalizedNodeStreamWriterStack.ofOperation((EffectiveModelContext)context, (SchemaNodeIdentifier.Absolute)operationPath, (QName)qname), preferPrefixes);
    }

    public static @NonNull NormalizedNodeStreamWriter createSchemaless(XMLStreamWriter writer) {
        return new SchemalessXMLStreamNormalizedNodeStreamWriter(writer);
    }

    public final List<NormalizedNodeStreamWriter.MetadataExtension> supportedExtensions() {
        return List.of(this);
    }

    abstract void startAnydata(YangInstanceIdentifier.NodeIdentifier var1);

    abstract void startList(YangInstanceIdentifier.NodeIdentifier var1);

    abstract void startListItem(YangInstanceIdentifier.PathArgument var1) throws IOException;

    abstract String encodeAnnotationValue(@NonNull ValueWriter var1, @NonNull QName var2, @NonNull Object var3) throws XMLStreamException;

    abstract String encodeValue(@NonNull ValueWriter var1, @NonNull Object var2, T var3) throws XMLStreamException;

    final void writeValue(@NonNull Object value, T context) throws IOException {
        try {
            this.facade.writeCharacters(this.encodeValue(this.facade, value, context));
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to write value", e);
        }
    }

    final void startElement(QName qname) throws IOException {
        try {
            this.facade.writeStartElement(qname);
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to start element", e);
        }
    }

    final void endElement() throws IOException {
        try {
            this.facade.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to end element", e);
        }
    }

    final void anydataValue(Object value) throws IOException {
        if (value instanceof DOMSourceAnydata) {
            try {
                this.facade.anydataWriteStreamReader(((DOMSourceAnydata)((Object)value)).toStreamReader());
            }
            catch (XMLStreamException e) {
                throw new IOException("Unable to transform anydata value: " + value, e);
            }
        } else if (value instanceof NormalizedAnydata) {
            try {
                this.facade.emitNormalizedAnydata((NormalizedAnydata)value);
            }
            catch (XMLStreamException e) {
                throw new IOException("Unable to emit anydata value: " + value, e);
            }
        } else {
            throw new IllegalStateException("Unexpected anydata value " + value);
        }
    }

    final void anyxmlValue(DOMSource domSource) throws IOException {
        if (domSource != null) {
            Node domNode = Objects.requireNonNull(domSource.getNode());
            try {
                this.facade.anyxmlWriteStreamReader(new DOMSourceXMLStreamReader(domSource));
            }
            catch (XMLStreamException e) {
                throw new IOException("Unable to transform anyXml value: " + domNode, e);
            }
        }
    }

    public final void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.startListItem((YangInstanceIdentifier.PathArgument)name);
    }

    public final void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) throws IOException {
        this.startListItem((YangInstanceIdentifier.PathArgument)identifier);
    }

    public final void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.startList(name);
    }

    public final void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.startList(name);
    }

    public final void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.startList(name);
    }

    public final void close() throws IOException {
        try {
            this.facade.close();
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to close writer", e);
        }
    }

    public final void flush() throws IOException {
        try {
            this.facade.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to flush writer", e);
        }
    }

    public final void metadata(ImmutableMap<QName, Object> attributes) throws IOException {
        for (Map.Entry entry : attributes.entrySet()) {
            QName qname = (QName)entry.getKey();
            String namespace = qname.getNamespace().toString();
            String localName = qname.getLocalName();
            Object value = entry.getValue();
            try {
                if (namespace.isEmpty()) {
                    StreamWriterFacade.warnLegacyAttribute(localName);
                    if (!(value instanceof String)) {
                        if (BROKEN_ATTRIBUTES.add(localName)) {
                            LOG.warn("Unbound annotation {} does not have a String value, ignoring it. Please fix the source of this annotation either by formatting it to a String or removing its use", (Object)localName, (Object)new Throwable("Call stack"));
                        }
                        LOG.debug("Ignoring annotation {} value {}", (Object)localName, value);
                        continue;
                    }
                    this.facade.writeAttribute(localName, (String)value);
                    continue;
                }
                String prefix = this.facade.getPrefix(qname.getNamespace(), namespace);
                String attrValue = this.encodeAnnotationValue(this.facade, qname, value);
                this.facade.writeAttribute(prefix, namespace, localName, attrValue);
            }
            catch (XMLStreamException e) {
                throw new IOException("Unable to emit attribute " + qname, e);
            }
        }
    }

    public final boolean startAnydataNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) throws IOException {
        if (DOMSourceAnydata.class.isAssignableFrom(objectModel) || NormalizedAnydata.class.isAssignableFrom(objectModel)) {
            this.startAnydata(name);
            this.startElement(name.getNodeType());
            return true;
        }
        return false;
    }
}

