/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationSchemaNode;
import org.opendaylight.yangtools.yang.common.AnnotationName;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.xml.PreferredPrefixes;
import org.opendaylight.yangtools.yang.data.codec.xml.SchemaAwareXMLStreamWriterUtils;
import org.opendaylight.yangtools.yang.data.codec.xml.ValueWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.util.NormalizedNodeStreamWriterStack;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnydataEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnyxmlEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.InputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;

final class SchemaAwareXMLStreamNormalizedNodeStreamWriter
extends XMLStreamNormalizedNodeStreamWriter<TypedDataSchemaNode> {
    private final NormalizedNodeStreamWriterStack tracker;
    private final SchemaAwareXMLStreamWriterUtils streamUtils;

    private SchemaAwareXMLStreamNormalizedNodeStreamWriter(XMLStreamWriter writer, EffectiveModelContext modelContext, NormalizedNodeStreamWriterStack tracker, @Nullable PreferredPrefixes pref) {
        super(writer, pref);
        this.tracker = Objects.requireNonNull(tracker);
        this.streamUtils = new SchemaAwareXMLStreamWriterUtils(modelContext, pref);
    }

    SchemaAwareXMLStreamNormalizedNodeStreamWriter(XMLStreamWriter writer, EffectiveModelContext modelContext, NormalizedNodeStreamWriterStack tracker, boolean modelPrefixes) {
        this(writer, modelContext, tracker, modelPrefixes ? new PreferredPrefixes.Shared(modelContext) : null);
    }

    @Override
    String encodeValue(ValueWriter xmlWriter, Object value, TypedDataSchemaNode schemaNode) throws XMLStreamException {
        return this.streamUtils.encodeValue(xmlWriter, this.resolveType(schemaNode.getType()), value, schemaNode.getQName().getModule());
    }

    @Override
    String encodeAnnotationValue(ValueWriter xmlWriter, QName qname, Object value) throws XMLStreamException {
        Optional optAnnotation = AnnotationSchemaNode.find((SchemaContext)this.streamUtils.modelContext(), (AnnotationName)new AnnotationName(qname));
        if (optAnnotation.isPresent()) {
            return this.streamUtils.encodeValue(xmlWriter, this.resolveType(((AnnotationSchemaNode)optAnnotation.orElseThrow()).getType()), value, qname.getModule());
        }
        if (qname.getRevision().isPresent()) {
            throw new IllegalArgumentException("Failed to find bound annotation " + String.valueOf(qname));
        }
        if (value instanceof String) {
            String str = (String)value;
            return str;
        }
        throw new IllegalArgumentException("Invalid non-string value " + String.valueOf(value) + " for unbound annotation " + String.valueOf(qname));
    }

    @Override
    void startList(YangInstanceIdentifier.NodeIdentifier name) {
        this.tracker.startList((YangInstanceIdentifier.PathArgument)name);
    }

    @Override
    void startListItem(YangInstanceIdentifier.PathArgument name) throws IOException {
        this.tracker.startListItem(name);
        this.startElement(name.getNodeType());
    }

    public void endNode() throws IOException {
        EffectiveStatement schema = this.tracker.endNode();
        if (schema instanceof ListEffectiveStatement || schema instanceof LeafListEffectiveStatement) {
            if (this.tracker.currentStatement() == schema) {
                this.endElement();
            }
        } else if (schema instanceof ContainerEffectiveStatement || schema instanceof LeafEffectiveStatement || schema instanceof AnydataEffectiveStatement || schema instanceof AnyxmlEffectiveStatement || schema instanceof InputEffectiveStatement || schema instanceof OutputEffectiveStatement || schema instanceof NotificationEffectiveStatement) {
            this.endElement();
        }
    }

    public void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) throws IOException {
        this.tracker.startLeafNode(name);
        this.startElement(name.getNodeType());
    }

    public void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) throws IOException {
        this.tracker.startLeafSetEntryNode(name);
        this.startElement(name.getNodeType());
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.tracker.startLeafSet(name);
    }

    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.tracker.startLeafSet(name);
    }

    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.tracker.startContainerNode(name);
        this.startElement(name.getNodeType());
    }

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.tracker.startChoiceNode(name);
    }

    public boolean startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) throws IOException {
        if (DOMSource.class.isAssignableFrom(objectModel)) {
            this.tracker.startAnyxmlNode(name);
            this.startElement(name.getNodeType());
            return true;
        }
        return false;
    }

    public void scalarValue(Object value) throws IOException {
        EffectiveStatement current;
        EffectiveStatement effectiveStatement = current = this.tracker.currentStatement();
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TypedDataSchemaNode.class, AnydataEffectiveStatement.class}, (Object)effectiveStatement, n)) {
            case 0: {
                TypedDataSchemaNode typedSchema = (TypedDataSchemaNode)effectiveStatement;
                this.writeValue(value, typedSchema);
                break;
            }
            case 1: {
                AnydataEffectiveStatement anyData = (AnydataEffectiveStatement)effectiveStatement;
                this.anydataValue(value);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected scalar value " + String.valueOf(value) + " with " + String.valueOf(current));
            }
        }
    }

    public void domSourceValue(DOMSource value) throws IOException {
        EffectiveStatement current = this.tracker.currentStatement();
        Preconditions.checkState((boolean)(current instanceof AnyxmlEffectiveStatement), (String)"Unexpected value %s with %s", (Object)value, (Object)current);
        this.anyxmlValue(value);
    }

    @Override
    void startAnydata(YangInstanceIdentifier.NodeIdentifier name) {
        this.tracker.startAnydataNode(name);
    }

    private @NonNull TypeDefinition<?> resolveType(@NonNull TypeDefinition<?> type) throws XMLStreamException {
        if (type instanceof LeafrefTypeDefinition) {
            LeafrefTypeDefinition leafref = (LeafrefTypeDefinition)type;
            try {
                return this.tracker.resolveLeafref(leafref);
            }
            catch (IllegalArgumentException e) {
                throw new XMLStreamException("Cannot resolve type " + String.valueOf(type), e);
            }
        }
        return type;
    }
}

