/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.annotations.VisibleForTesting;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLStreamException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.xml.ValueWriter;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class XMLStreamWriterUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XMLStreamWriterUtils.class);
    private static final Set<QName> IDENTITYREF_WARNED = ConcurrentHashMap.newKeySet();

    XMLStreamWriterUtils() {
    }

    String encodeValue(@NonNull ValueWriter writer, @NonNull TypeDefinition<?> type, @NonNull Object value, QNameModule parent) throws XMLStreamException {
        TypeDefinition<?> typeDefinition = type;
        Objects.requireNonNull(typeDefinition);
        TypeDefinition<?> typeDefinition2 = typeDefinition;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IdentityrefTypeDefinition.class, InstanceIdentifierTypeDefinition.class, UnionTypeDefinition.class}, typeDefinition2, n)) {
            case 0 -> {
                IdentityrefTypeDefinition identityref = (IdentityrefTypeDefinition)typeDefinition2;
                yield XMLStreamWriterUtils.encode(writer, identityref, value, parent);
            }
            case 1 -> {
                InstanceIdentifierTypeDefinition instanceIdentifier = (InstanceIdentifierTypeDefinition)typeDefinition2;
                yield this.encode(writer, instanceIdentifier, value);
            }
            case 2 -> {
                UnionTypeDefinition union = (UnionTypeDefinition)typeDefinition2;
                Object v2 = value;
                Objects.requireNonNull(v2);
                Object var12_10 = v2;
                int var13_11 = 0;
                block9: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{QName.class, YangInstanceIdentifier.class}, (Object)var12_10, var13_11)) {
                        case 0: {
                            QName qname = (QName)var12_10;
                            if (!XMLStreamWriterUtils.isIdentityref(union)) {
                                var13_11 = 1;
                                continue block9;
                            }
                            yield XMLStreamWriterUtils.encode(writer, qname, parent);
                        }
                        case 1: {
                            YangInstanceIdentifier iid = (YangInstanceIdentifier)var12_10;
                            if (!this.isInstanceIdentifier(union)) {
                                var13_11 = 2;
                                continue block9;
                            }
                            yield this.encode(writer, iid);
                        }
                    }
                    break;
                }
                yield XMLStreamWriterUtils.serialize(type, value);
            }
            default -> XMLStreamWriterUtils.serialize(type, value);
        };
    }

    private static boolean isIdentityref(UnionTypeDefinition union) {
        for (TypeDefinition subtype : union.getTypes()) {
            UnionTypeDefinition unionSub;
            if (!(subtype instanceof IdentityrefTypeDefinition) && (!(subtype instanceof UnionTypeDefinition) || !XMLStreamWriterUtils.isIdentityref(unionSub = (UnionTypeDefinition)subtype))) continue;
            return true;
        }
        return false;
    }

    private boolean isInstanceIdentifier(UnionTypeDefinition union) {
        for (TypeDefinition subtype : union.getTypes()) {
            UnionTypeDefinition unionSub;
            if (!(subtype instanceof InstanceIdentifierTypeDefinition) && (!(subtype instanceof UnionTypeDefinition) || !this.isInstanceIdentifier(unionSub = (UnionTypeDefinition)subtype))) continue;
            return true;
        }
        return false;
    }

    private static String serialize(@NonNull TypeDefinition<?> type, @NonNull Object value) {
        TypeDefinitionAwareCodec codec = TypeDefinitionAwareCodec.from(type);
        if (codec == null) {
            LOG.warn("Failed to find codec for {}, falling back to using stream", type);
            return value.toString();
        }
        try {
            return (String)codec.serialize(value);
        }
        catch (ClassCastException e) {
            LOG.warn("Provided node value {} did not have type {} required by mapping. Using stream instead.", new Object[]{value, type, e});
            return value.toString();
        }
    }

    @VisibleForTesting
    static String encode(@NonNull ValueWriter writer, @NonNull QName qname, QNameModule parent) throws XMLStreamException {
        if (qname.getNamespace().equals((Object)parent.namespace())) {
            return qname.getLocalName();
        }
        String ns = qname.getNamespace().toString();
        String prefix = "x";
        writer.writeNamespace("x", ns);
        return "x:" + qname.getLocalName();
    }

    private static String encode(@NonNull ValueWriter writer, @NonNull IdentityrefTypeDefinition type, @NonNull Object value, QNameModule parent) throws XMLStreamException {
        if (value instanceof QName) {
            QName qname = (QName)value;
            return XMLStreamWriterUtils.encode(writer, qname, parent);
        }
        QName qname = type.getQName();
        if (IDENTITYREF_WARNED.add(qname)) {
            LOG.warn("Value of {}:{} is not a QName but {}. Please the source of this data", new Object[]{qname.getNamespace(), qname.getLocalName(), value.getClass(), new Throwable()});
        }
        return value.toString();
    }

    private String encode(@NonNull ValueWriter writer, @NonNull InstanceIdentifierTypeDefinition type, @NonNull Object value) throws XMLStreamException {
        if (value instanceof YangInstanceIdentifier) {
            YangInstanceIdentifier instanceIdentifier = (YangInstanceIdentifier)value;
            return this.encode(writer, instanceIdentifier);
        }
        QName qname = type.getQName();
        LOG.warn("Value of {}:{} is not an InstanceIdentifier but {}", new Object[]{qname.getNamespace(), qname.getLocalName(), value.getClass()});
        return value.toString();
    }

    abstract String encode(@NonNull ValueWriter var1, YangInstanceIdentifier var2) throws XMLStreamException;
}

