/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.impl.codec.AbstractDataStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.AbstractIntegerStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BinaryStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BitsStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BooleanStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.DecimalStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.EmptyStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.EnumStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.StringStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.UnionStringCodec;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.slf4j.LoggerFactory;

public abstract class TypeDefinitionAwareCodec<J, T extends TypeDefinition<T>>
extends AbstractDataStringCodec<J> {
    private static final boolean ENABLE_UNION_CODEC;
    private final @NonNull Class<J> inputClass;
    private final @Nullable T typeDefinition;

    protected TypeDefinitionAwareCodec(@Nullable T typeDefinition, Class<J> outputClass) {
        this.typeDefinition = typeDefinition;
        this.inputClass = Objects.requireNonNull(outputClass);
    }

    @Override
    public Class<J> getInputClass() {
        return this.inputClass;
    }

    public Optional<T> getTypeDefinition() {
        return Optional.ofNullable(this.typeDefinition);
    }

    public static TypeDefinitionAwareCodec<Object, ?> from(TypeDefinition<?> typeDefinition) {
        return TypeDefinitionAwareCodec.fromType(typeDefinition);
    }

    public static @Nullable TypeDefinitionAwareCodec<?, ?> fromType(TypeDefinition<?> typeDefinition) {
        if (typeDefinition instanceof BinaryTypeDefinition) {
            return BinaryStringCodec.from((BinaryTypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof BitsTypeDefinition) {
            return BitsStringCodec.from((BitsTypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof BooleanTypeDefinition) {
            return BooleanStringCodec.from((BooleanTypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof DecimalTypeDefinition) {
            return DecimalStringCodec.from((DecimalTypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof EmptyTypeDefinition) {
            return EmptyStringCodec.INSTANCE;
        }
        if (typeDefinition instanceof EnumTypeDefinition) {
            return EnumStringCodec.from((EnumTypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof Int8TypeDefinition) {
            return AbstractIntegerStringCodec.from((Int8TypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof Int16TypeDefinition) {
            return AbstractIntegerStringCodec.from((Int16TypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof Int32TypeDefinition) {
            return AbstractIntegerStringCodec.from((Int32TypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof Int64TypeDefinition) {
            return AbstractIntegerStringCodec.from((Int64TypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof StringTypeDefinition) {
            return StringStringCodec.from((StringTypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof Uint8TypeDefinition) {
            return AbstractIntegerStringCodec.from((Uint8TypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof Uint16TypeDefinition) {
            return AbstractIntegerStringCodec.from((Uint16TypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof Uint32TypeDefinition) {
            return AbstractIntegerStringCodec.from((Uint32TypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof Uint64TypeDefinition) {
            return AbstractIntegerStringCodec.from((Uint64TypeDefinition)typeDefinition);
        }
        if (ENABLE_UNION_CODEC && typeDefinition instanceof UnionTypeDefinition) {
            return UnionStringCodec.from((UnionTypeDefinition)typeDefinition);
        }
        return null;
    }

    static {
        boolean bl = ENABLE_UNION_CODEC = !Boolean.getBoolean("org.opendaylight.yangtools.yang.data.impl.codec.disable-union");
        if (!ENABLE_UNION_CODEC) {
            LoggerFactory.getLogger(TypeDefinitionAwareCodec.class).info("Support for unions is disabled");
        }
    }
}

