/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.NormalizedNodeBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedMetadata;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizationResultHolder;

@Beta
public class ImmutableMetadataNormalizedNodeStreamWriter
extends ImmutableNormalizedNodeStreamWriter
implements NormalizedNodeStreamWriter.MetadataExtension {
    private final Deque<BuilderEntry> builders = new ArrayDeque<BuilderEntry>();
    private final NormalizationResultHolder holder;

    protected ImmutableMetadataNormalizedNodeStreamWriter(State state) {
        super(state.dataBuilder);
        this.builders.push(state.metaBuilder);
        this.holder = null;
    }

    protected ImmutableMetadataNormalizedNodeStreamWriter(NormalizationResultHolder holder) {
        super(holder);
        this.holder = Objects.requireNonNull(holder);
    }

    public final List<NormalizedNodeStreamWriter.MetadataExtension> supportedExtensions() {
        return List.of(this);
    }

    public final void metadata(ImmutableMap<QName, Object> metadata) throws IOException {
        BuilderEntry current = this.builders.peek();
        Preconditions.checkState((current != null ? 1 : 0) != 0, (Object)"Attempted to emit metadata when no metadata is open");
        current.builder.withAnnotations((Map<QName, Object>)metadata);
    }

    protected final @NonNull State popState() {
        return new State(this.popBuilder(), this.builders.pop());
    }

    @Override
    final void enter(YangInstanceIdentifier.PathArgument identifier, NormalizedNodeBuilder next) {
        super.enter(identifier, next);
        this.builders.push(new BuilderEntry(identifier, ImmutableNormalizedMetadata.builder()));
    }

    @Override
    public final void endNode() {
        super.endNode();
        BuilderEntry last = this.builders.pop();
        ImmutableNormalizedMetadata metadata = last.builder.build();
        BuilderEntry current = this.builders.peek();
        if (current != null) {
            if (!metadata.getAnnotations().isEmpty() || !metadata.getChildren().isEmpty()) {
                current.builder.withChild(last.identifier, metadata);
            }
        } else {
            this.holder.setMetadata(metadata);
        }
    }

    public static final class State {
        final BuilderEntry metaBuilder;
        final NormalizedNode.Builder dataBuilder;

        State(NormalizedNode.Builder dataBuilder, BuilderEntry metadataBuilder) {
            this.dataBuilder = Objects.requireNonNull(dataBuilder);
            this.metaBuilder = Objects.requireNonNull(metadataBuilder);
        }

        public NormalizedNode.Builder getDataBuilder() {
            return this.dataBuilder;
        }

        public ImmutableNormalizedMetadata.Builder getMetaBuilder() {
            return this.metaBuilder.builder;
        }
    }

    @NonNullByDefault
    private record BuilderEntry(YangInstanceIdentifier.PathArgument identifier, ImmutableNormalizedMetadata.Builder builder) {
        BuilderEntry {
            Objects.requireNonNull(identifier);
            Objects.requireNonNull(builder);
        }
    }
}

