/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import com.google.common.annotations.Beta;
import com.google.common.collect.RangeSet;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.data.api.codec.BinaryCodec;
import org.opendaylight.yangtools.yang.data.api.codec.YangInvalidValueException;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;

@Beta
public abstract sealed class BinaryStringCodec
extends TypeDefinitionAwareCodec<byte[], BinaryTypeDefinition>
implements BinaryCodec<String> {
    BinaryStringCodec(BinaryTypeDefinition typeDef) {
        super(byte[].class, typeDef);
    }

    public static BinaryStringCodec from(BinaryTypeDefinition type) {
        Optional optConstraint = type.getLengthConstraint();
        return optConstraint.isPresent() ? new Restricted(type, (LengthConstraint)optConstraint.orElseThrow()) : new Unrestricted(type);
    }

    public final byte[] deserializeImpl(String product) {
        byte[] ret = Base64.getMimeDecoder().decode(product);
        this.validate(ret);
        return ret;
    }

    protected final String serializeImpl(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    abstract void validate(byte[] var1);

    private static final class Restricted
    extends BinaryStringCodec {
        private final LengthConstraint lengthConstraint;

        Restricted(BinaryTypeDefinition typeDef, LengthConstraint lengthConstraint) {
            super(typeDef);
            this.lengthConstraint = Objects.requireNonNull(lengthConstraint);
        }

        @Override
        void validate(byte[] value) {
            RangeSet ranges = this.lengthConstraint.getAllowedRanges();
            if (!ranges.contains((Comparable)Integer.valueOf(value.length))) {
                throw new YangInvalidValueException(ErrorType.APPLICATION, (ConstraintMetaDefinition)this.lengthConstraint, "Value length " + value.length + " is not in required ranges " + String.valueOf(ranges));
            }
        }
    }

    private static final class Unrestricted
    extends BinaryStringCodec {
        Unrestricted(BinaryTypeDefinition typeDef) {
            super(typeDef);
        }

        @Override
        void validate(byte[] value) {
        }
    }
}

