/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import com.google.common.annotations.Beta;
import com.google.common.collect.RangeSet;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.data.api.codec.StringCodec;
import org.opendaylight.yangtools.yang.data.api.codec.YangInvalidValueException;
import org.opendaylight.yangtools.yang.data.impl.codec.StringPatternCheckingCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;

@Beta
public class StringStringCodec
extends TypeDefinitionAwareCodec<String, StringTypeDefinition>
implements StringCodec<String> {
    private final LengthConstraint lengthConstraint;

    StringStringCodec(StringTypeDefinition typeDef) {
        super(String.class, typeDef);
        this.lengthConstraint = typeDef.getLengthConstraint().orElse(null);
    }

    public static StringStringCodec from(StringTypeDefinition normalizedType) {
        return normalizedType.getPatternConstraints().isEmpty() ? new StringStringCodec(normalizedType) : new StringPatternCheckingCodec(normalizedType);
    }

    protected final String deserializeImpl(String stringRepresentation) {
        this.validate(stringRepresentation);
        return stringRepresentation;
    }

    protected final String serializeImpl(String data) {
        return data;
    }

    void validate(String str) {
        RangeSet ranges;
        if (this.lengthConstraint != null && !(ranges = this.lengthConstraint.getAllowedRanges()).contains((Comparable)Integer.valueOf(str.codePointCount(0, str.length())))) {
            throw new YangInvalidValueException(ErrorType.APPLICATION, (ConstraintMetaDefinition)this.lengthConstraint, "String " + str + " does not match allowed lengths " + String.valueOf(ranges));
        }
    }
}

