/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.impl.codec.AbstractDataStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.AbstractIntegerStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BinaryStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BitsStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BooleanStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.DecimalStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.EmptyStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.EnumStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.StringStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.UnionStringCodec;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.slf4j.LoggerFactory;

public abstract class TypeDefinitionAwareCodec<J, T extends TypeDefinition<T>>
extends AbstractDataStringCodec<J> {
    private static final boolean ENABLE_UNION_CODEC;
    private final @NonNull Class<J> inputClass;
    private final @NonNull T typeDefinition;

    protected TypeDefinitionAwareCodec(Class<J> outputClass, T typeDefinition) {
        this.inputClass = Objects.requireNonNull(outputClass);
        this.typeDefinition = (TypeDefinition)Objects.requireNonNull(typeDefinition);
    }

    @Override
    public final Class<J> getInputClass() {
        return this.inputClass;
    }

    protected final @NonNull T typeDefinition() {
        return this.typeDefinition;
    }

    public static TypeDefinitionAwareCodec<Object, ?> from(TypeDefinition<?> typeDefinition) {
        return TypeDefinitionAwareCodec.fromType(typeDefinition);
    }

    public static @Nullable TypeDefinitionAwareCodec<?, ?> fromType(TypeDefinition<?> typeDefinition) {
        TypeDefinitionAwareCodec typeDefinitionAwareCodec;
        TypeDefinition<?> typeDefinition2 = typeDefinition;
        Objects.requireNonNull(typeDefinition2);
        TypeDefinition<?> typeDefinition3 = typeDefinition2;
        int n = 0;
        block18: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BinaryTypeDefinition.class, BitsTypeDefinition.class, BooleanTypeDefinition.class, DecimalTypeDefinition.class, EmptyTypeDefinition.class, EnumTypeDefinition.class, Int8TypeDefinition.class, Int16TypeDefinition.class, Int32TypeDefinition.class, Int64TypeDefinition.class, StringTypeDefinition.class, Uint8TypeDefinition.class, Uint16TypeDefinition.class, Uint32TypeDefinition.class, Uint64TypeDefinition.class, UnionTypeDefinition.class}, typeDefinition3, n)) {
                case 0: {
                    BinaryTypeDefinition binaryType = (BinaryTypeDefinition)typeDefinition3;
                    typeDefinitionAwareCodec = BinaryStringCodec.from(binaryType);
                    break block18;
                }
                case 1: {
                    BitsTypeDefinition bitsType = (BitsTypeDefinition)typeDefinition3;
                    typeDefinitionAwareCodec = BitsStringCodec.from(bitsType);
                    break block18;
                }
                case 2: {
                    BooleanTypeDefinition booleanType = (BooleanTypeDefinition)typeDefinition3;
                    typeDefinitionAwareCodec = BooleanStringCodec.from(booleanType);
                    break block18;
                }
                case 3: {
                    DecimalTypeDefinition decimalType = (DecimalTypeDefinition)typeDefinition3;
                    typeDefinitionAwareCodec = DecimalStringCodec.from(decimalType);
                    break block18;
                }
                case 4: {
                    EmptyTypeDefinition emptyType = (EmptyTypeDefinition)typeDefinition3;
                    typeDefinitionAwareCodec = new EmptyStringCodec(emptyType);
                    break block18;
                }
                case 5: {
                    EnumTypeDefinition enumType = (EnumTypeDefinition)typeDefinition3;
                    typeDefinitionAwareCodec = EnumStringCodec.from(enumType);
                    break block18;
                }
                case 6: {
                    Int8TypeDefinition int8Type = (Int8TypeDefinition)typeDefinition3;
                    typeDefinitionAwareCodec = AbstractIntegerStringCodec.from(int8Type);
                    break block18;
                }
                case 7: {
                    Int16TypeDefinition int16Type = (Int16TypeDefinition)typeDefinition3;
                    typeDefinitionAwareCodec = AbstractIntegerStringCodec.from(int16Type);
                    break block18;
                }
                case 8: {
                    Int32TypeDefinition int32Type = (Int32TypeDefinition)typeDefinition3;
                    typeDefinitionAwareCodec = AbstractIntegerStringCodec.from(int32Type);
                    break block18;
                }
                case 9: {
                    Int64TypeDefinition int64Type = (Int64TypeDefinition)typeDefinition3;
                    typeDefinitionAwareCodec = AbstractIntegerStringCodec.from(int64Type);
                    break block18;
                }
                case 10: {
                    StringTypeDefinition stringType = (StringTypeDefinition)typeDefinition3;
                    typeDefinitionAwareCodec = StringStringCodec.from(stringType);
                    break block18;
                }
                case 11: {
                    Uint8TypeDefinition uint8Type = (Uint8TypeDefinition)typeDefinition3;
                    typeDefinitionAwareCodec = AbstractIntegerStringCodec.from(uint8Type);
                    break block18;
                }
                case 12: {
                    Uint16TypeDefinition uint16Type = (Uint16TypeDefinition)typeDefinition3;
                    typeDefinitionAwareCodec = AbstractIntegerStringCodec.from(uint16Type);
                    break block18;
                }
                case 13: {
                    Uint32TypeDefinition uint32Type = (Uint32TypeDefinition)typeDefinition3;
                    typeDefinitionAwareCodec = AbstractIntegerStringCodec.from(uint32Type);
                    break block18;
                }
                case 14: {
                    Uint64TypeDefinition uint64Type = (Uint64TypeDefinition)typeDefinition3;
                    typeDefinitionAwareCodec = AbstractIntegerStringCodec.from(uint64Type);
                    break block18;
                }
                case 15: {
                    UnionTypeDefinition unionType = (UnionTypeDefinition)typeDefinition3;
                    if (!ENABLE_UNION_CODEC) {
                        n = 16;
                        continue block18;
                    }
                    typeDefinitionAwareCodec = UnionStringCodec.from(unionType);
                    break block18;
                }
                default: {
                    typeDefinitionAwareCodec = null;
                    break block18;
                }
            }
            break;
        }
        return typeDefinitionAwareCodec;
    }

    static {
        boolean bl = ENABLE_UNION_CODEC = !Boolean.getBoolean("org.opendaylight.yangtools.yang.data.impl.codec.disable-union");
        if (!ENABLE_UNION_CODEC) {
            LoggerFactory.getLogger(TypeDefinitionAwareCodec.class).info("Support for unions is disabled");
        }
    }
}

