/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.annotations.Beta;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.data.api.YangErrorInfo;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;

@Beta
@NonNullByDefault
public final class YangErrorInfos {
    private static final YangInstanceIdentifier.NodeIdentifier BAD_ATTRIBUTE_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangConstants.BAD_ATTRIBUTE_QNAME);
    private static final YangInstanceIdentifier.NodeIdentifier BAD_ELEMENT_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangConstants.BAD_ELEMENT_QNAME);
    private static final YangInstanceIdentifier.NodeIdentifier BAD_NAMESPACE_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangConstants.BAD_NAMESPACE_QNAME);
    private static final YangInstanceIdentifier.NodeIdentifier MISSING_CHOICE_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangConstants.MISSING_CHOICE_QNAME);
    private static final YangInstanceIdentifier.NodeIdentifier NON_UNIQUE_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangConstants.NON_UNIQUE_QNAME);
    private static final YangInstanceIdentifier.NodeIdentifier SESSION_ID_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangConstants.SESSION_ID_QNAME);
    @Deprecated(since="RFC6241")
    private static final YangInstanceIdentifier.NodeIdentifier ERR_ELEMENT_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangConstants.ERR_ELEMENT_QNAME);
    @Deprecated(since="RFC6241")
    private static final YangInstanceIdentifier.NodeIdentifier NOOP_ELEMENT_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangConstants.NOOP_ELEMENT_QNAME);
    @Deprecated(since="RFC6241")
    private static final YangInstanceIdentifier.NodeIdentifier OK_ELEMENT_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangConstants.OK_ELEMENT_QNAME);

    private YangErrorInfos() {
    }

    public static YangErrorInfo of(QName name, Object value) {
        return YangErrorInfos.of(new YangInstanceIdentifier.NodeIdentifier(name), value);
    }

    public static YangErrorInfo of(YangInstanceIdentifier.NodeIdentifier name, Object value) {
        return YangErrorInfo.of((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)name, (Object)value));
    }

    public static YangErrorInfo badAttribute(QName attributeName) {
        return YangErrorInfos.of(BAD_ATTRIBUTE_NODEID, (Object)attributeName);
    }

    public static YangErrorInfo badElement(QName elementName) {
        return YangErrorInfos.of(BAD_ELEMENT_NODEID, (Object)elementName);
    }

    public static YangErrorInfo badNamespace(QName namespaceName) {
        return YangErrorInfos.of(BAD_NAMESPACE_NODEID, (Object)namespaceName);
    }

    public static YangErrorInfo sessionId(Uint32 sessionId) {
        return YangErrorInfos.of(SESSION_ID_NODEID, (Object)sessionId);
    }

    @Deprecated(since="RFC6241")
    public static YangErrorInfo errElement(QName elementName) {
        return YangErrorInfos.of(ERR_ELEMENT_NODEID, (Object)elementName);
    }

    @Deprecated(since="RFC6241")
    public static YangErrorInfo noopElement(QName elementName) {
        return YangErrorInfos.of(NOOP_ELEMENT_NODEID, (Object)elementName);
    }

    @Deprecated(since="RFC6241")
    public static YangErrorInfo okElement(QName elementName) {
        return YangErrorInfos.of(OK_ELEMENT_NODEID, (Object)elementName);
    }

    public static YangErrorInfo nonUnique(YangInstanceIdentifier leafPath) {
        return YangErrorInfos.of(NON_UNIQUE_NODEID, (Object)leafPath);
    }

    public static YangErrorInfo missingChoice(YangInstanceIdentifier.NodeIdentifier choiceName) {
        return YangErrorInfos.of(MISSING_CHOICE_NODEID, (Object)choiceName);
    }
}

