/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.spi.node.impl;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AbstractLeafNode;

public abstract sealed class ImmutableLeafNode<T>
extends AbstractLeafNode<T> {
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier name;
    private final @NonNull T value;

    private ImmutableLeafNode(YangInstanceIdentifier.NodeIdentifier name, T value) {
        this.name = Objects.requireNonNull(name);
        this.value = Objects.requireNonNull(value);
    }

    public static <T> @NonNull ImmutableLeafNode<T> of(YangInstanceIdentifier.NodeIdentifier identifier, T value) {
        ImmutableLeafNode immutableLeafNode;
        T t = value;
        Objects.requireNonNull(t);
        T t2 = t;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{byte[].class, YangInstanceIdentifier.class}, t2, n)) {
                case 0: {
                    byte[] bytes = (byte[])t2;
                    Binary ret = new Binary(identifier, bytes);
                    immutableLeafNode = ret;
                    break block4;
                }
                case 1: {
                    YangInstanceIdentifier yiid = (YangInstanceIdentifier)t2;
                    if (!yiid.isEmpty()) {
                        n = 2;
                        continue block4;
                    }
                    throw new IllegalArgumentException("Leaf node value cannot be an empty instance identifier");
                }
                default: {
                    immutableLeafNode = new Regular<T>(identifier, value);
                    break block4;
                }
            }
            break;
        }
        return immutableLeafNode;
    }

    public final YangInstanceIdentifier.NodeIdentifier name() {
        return this.name;
    }

    protected final T value() {
        return this.value;
    }

    protected final Class<?> toStringClass() {
        return ImmutableLeafNode.class;
    }

    private static final class Binary
    extends ImmutableLeafNode<byte[]> {
        Binary(YangInstanceIdentifier.NodeIdentifier name, byte[] value) {
            super(name, value);
        }

        protected byte[] wrappedValue() {
            return (byte[])((byte[])this.value()).clone();
        }
    }

    private static final class Regular<T>
    extends ImmutableLeafNode<T> {
        Regular(YangInstanceIdentifier.NodeIdentifier name, T value) {
            super(name, value);
        }

        protected T wrappedValue() {
            return this.value();
        }
    }
}

