/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.spi.node.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.MapAdaptor;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.SystemLeafSetNode;
import org.opendaylight.yangtools.yang.data.spi.node.impl.ImmutableLeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.spi.node.impl.ImmutableSystemLeafSetNode;

public final class ImmutableSystemLeafSetNodeBuilder<T>
implements SystemLeafSetNode.Builder<T> {
    private static final int DEFAULT_CAPACITY = 4;
    private final Map<YangInstanceIdentifier.NodeWithValue<?>, LeafSetEntryNode<T>> value;
    private YangInstanceIdentifier.NodeIdentifier nodeIdentifier;

    public ImmutableSystemLeafSetNodeBuilder() {
        this.value = new HashMap(4);
    }

    public ImmutableSystemLeafSetNodeBuilder(int sizeHint) {
        this.value = sizeHint >= 0 ? HashMap.newHashMap(sizeHint) : new HashMap(4);
    }

    private ImmutableSystemLeafSetNodeBuilder(ImmutableSystemLeafSetNode<T> node) {
        this.nodeIdentifier = node.name();
        this.value = MapAdaptor.getDefaultInstance().takeSnapshot(node.children);
    }

    public static <T> // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SystemLeafSetNode.Builder<T> create(SystemLeafSetNode<T> node) {
        if (node instanceof ImmutableSystemLeafSetNode) {
            ImmutableSystemLeafSetNode immutable = (ImmutableSystemLeafSetNode)node;
            return new ImmutableSystemLeafSetNodeBuilder<T>(immutable);
        }
        throw new UnsupportedOperationException("Cannot initialize from class " + String.valueOf(node.getClass()));
    }

    public ImmutableSystemLeafSetNodeBuilder<T> withChild(LeafSetEntryNode<T> child) {
        this.value.put(child.name(), child);
        return this;
    }

    public ImmutableSystemLeafSetNodeBuilder<T> withoutChild(YangInstanceIdentifier.PathArgument key) {
        this.value.remove(key);
        return this;
    }

    public SystemLeafSetNode<T> build() {
        return new ImmutableSystemLeafSetNode(this.nodeIdentifier, MapAdaptor.getDefaultInstance().optimize(this.value));
    }

    public ImmutableSystemLeafSetNodeBuilder<T> withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        this.nodeIdentifier = withNodeIdentifier;
        return this;
    }

    public ImmutableSystemLeafSetNodeBuilder<T> withValue(Collection<LeafSetEntryNode<T>> withValue) {
        for (LeafSetEntryNode<T> leafSetEntry : withValue) {
            this.withChild(leafSetEntry);
        }
        return this;
    }

    public ImmutableSystemLeafSetNodeBuilder<T> withChildValue(T childValue) {
        return this.withChild((LeafSetEntryNode<T>)ImmutableLeafSetEntryNode.of(new YangInstanceIdentifier.NodeWithValue(this.nodeIdentifier.getNodeType(), childValue)));
    }

    public ImmutableSystemLeafSetNodeBuilder<T> addChild(LeafSetEntryNode<T> child) {
        return this.withChild(child);
    }

    public ImmutableSystemLeafSetNodeBuilder<T> removeChild(YangInstanceIdentifier.PathArgument key) {
        return this.withoutChild(key);
    }
}

