/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.spi.node.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.util.MapAdaptor;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.SystemMapNode;
import org.opendaylight.yangtools.yang.data.spi.node.impl.ImmutableSystemMapNode;

public final class ImmutableSystemMapNodeBuilder
implements SystemMapNode.Builder {
    private static final int DEFAULT_CAPACITY = 4;
    private final Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> value;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable YangInstanceIdentifier.NodeIdentifier nodeIdentifier = null;

    public ImmutableSystemMapNodeBuilder() {
        this.value = new HashMap<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>(4);
    }

    public ImmutableSystemMapNodeBuilder(int sizeHint) {
        this.value = sizeHint >= 0 ? HashMap.newHashMap(sizeHint) : new HashMap(4);
    }

    private ImmutableSystemMapNodeBuilder(SystemMapNode node) {
        this.nodeIdentifier = node.name();
        this.value = MapAdaptor.getDefaultInstance().takeSnapshot(ImmutableSystemMapNodeBuilder.accessChildren(node));
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SystemMapNode.Builder create(SystemMapNode node) {
        return new ImmutableSystemMapNodeBuilder(node);
    }

    public ImmutableSystemMapNodeBuilder withChild(MapEntryNode child) {
        this.value.put(child.name(), child);
        return this;
    }

    public ImmutableSystemMapNodeBuilder withoutChild(YangInstanceIdentifier.PathArgument key) {
        this.value.remove(key);
        return this;
    }

    public ImmutableSystemMapNodeBuilder withValue(Collection<MapEntryNode> withValue) {
        for (MapEntryNode mapEntryNode : withValue) {
            this.withChild(mapEntryNode);
        }
        return this;
    }

    public ImmutableSystemMapNodeBuilder withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        this.nodeIdentifier = withNodeIdentifier;
        return this;
    }

    public SystemMapNode build() {
        return new ImmutableSystemMapNode(this.nodeIdentifier, MapAdaptor.getDefaultInstance().optimize(this.value));
    }

    public ImmutableSystemMapNodeBuilder addChild(MapEntryNode child) {
        return this.withChild(child);
    }

    public ImmutableSystemMapNodeBuilder removeChild(YangInstanceIdentifier.PathArgument key) {
        return this.withoutChild(key);
    }

    static @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> accessChildren(SystemMapNode node) {
        Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> map;
        if (node instanceof ImmutableSystemMapNode) {
            ImmutableSystemMapNode immutableNode = (ImmutableSystemMapNode)node;
            map = immutableNode.children;
        } else {
            map = node.asMap();
        }
        return map;
    }
}

