/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.api;

import com.google.common.annotations.Beta;
import java.util.List;
import java.util.OptionalInt;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.data.api.ImmutableYangNetconfError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangNetconfError;
import org.opendaylight.yangtools.yang.data.api.YangNetconfErrorAware;
import org.opendaylight.yangtools.yang.data.tree.api.DataValidationFailedException;

@Beta
@NonNullByDefault
public final class RequiredElementCountException
extends DataValidationFailedException
implements YangNetconfErrorAware {
    private static final long serialVersionUID = 1L;
    private final int actualCount;
    private final int minimumCount;
    private final int maximumCount;

    public RequiredElementCountException(YangInstanceIdentifier path, int actualCount, int minimumCount, int maximumCount, String message) {
        super(path, message);
        this.minimumCount = minimumCount;
        this.maximumCount = maximumCount;
        this.actualCount = actualCount;
    }

    public RequiredElementCountException(YangInstanceIdentifier path, int actualCount, int minimumCount, int maximumCount, String format, Object ... args) {
        this(path, actualCount, minimumCount, maximumCount, String.format(format, args));
    }

    public OptionalInt getMinimumCount() {
        return this.minimumCount == 0 ? OptionalInt.empty() : OptionalInt.of(this.minimumCount);
    }

    public OptionalInt getMaximumCount() {
        return this.maximumCount == Integer.MAX_VALUE ? OptionalInt.empty() : OptionalInt.of(this.maximumCount);
    }

    public int getActualCount() {
        return this.actualCount;
    }

    public List<YangNetconfError> getNetconfErrors() {
        String appTag;
        if (this.actualCount < this.minimumCount) {
            appTag = "too-few-elements";
        } else if (this.actualCount > this.maximumCount) {
            appTag = "too-many-elements";
        } else {
            throw new IllegalStateException("Invalid min " + this.minimumCount + " max " + this.maximumCount + " actual " + this.actualCount);
        }
        return List.of(ImmutableYangNetconfError.builder().severity(ErrorSeverity.ERROR).type(ErrorType.APPLICATION).tag(ErrorTag.OPERATION_FAILED).appTag(appTag).build());
    }
}

