/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.api;

import com.google.common.base.Verify;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;

public interface DataTreeCandidateNode {
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.PathArgument name();

    public @NonNull Collection<DataTreeCandidateNode> childNodes();

    public @Nullable DataTreeCandidateNode modifiedChild(YangInstanceIdentifier.PathArgument var1);

    default public @NonNull Optional<DataTreeCandidateNode> findModifiedChild(YangInstanceIdentifier.PathArgument childName) {
        return Optional.ofNullable(this.modifiedChild(childName));
    }

    default public @NonNull DataTreeCandidateNode getModifiedChild(YangInstanceIdentifier.PathArgument childName) {
        return (DataTreeCandidateNode)Verify.verifyNotNull((Object)this.modifiedChild(childName), (String)"No modified child named %s", (Object[])new Object[]{childName});
    }

    public @NonNull ModificationType modificationType();

    public @Nullable NormalizedNode dataBefore();

    default public @NonNull Optional<NormalizedNode> findDataBefore() {
        return Optional.ofNullable(this.dataBefore());
    }

    default public @NonNull NormalizedNode getDataBefore() {
        return (NormalizedNode)Verify.verifyNotNull((Object)this.dataBefore(), (String)"No before-image available", (Object[])new Object[0]);
    }

    public @Nullable NormalizedNode dataAfter();

    default public @NonNull Optional<NormalizedNode> findDataAfter() {
        return Optional.ofNullable(this.dataAfter());
    }

    default public @NonNull NormalizedNode getDataAfter() {
        return (NormalizedNode)Verify.verifyNotNull((Object)this.dataAfter(), (String)"No after-image available", (Object[])new Object[0]);
    }
}

