/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.MoreObjects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableUnkeyedListEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableUnkeyedListNodeBuilder;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.api.IncorrectDataStructureException;
import org.opendaylight.yangtools.yang.data.tree.impl.AutomaticLifecycleMixin;
import org.opendaylight.yangtools.yang.data.tree.impl.ChildTrackingPolicy;
import org.opendaylight.yangtools.yang.data.tree.impl.DataNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationPath;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.NodeModification;
import org.opendaylight.yangtools.yang.data.tree.impl.NormalizedNodeContainerSupport;
import org.opendaylight.yangtools.yang.data.tree.impl.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.node.MutableTreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

final class ListModificationStrategy
extends SchemaAwareApplyOperation<ListSchemaNode> {
    private static final NormalizedNodeContainerSupport<YangInstanceIdentifier.NodeIdentifier, UnkeyedListEntryNode> ITEM_SUPPORT = new NormalizedNodeContainerSupport(UnkeyedListEntryNode.class, ImmutableUnkeyedListEntryNodeBuilder::create, ImmutableUnkeyedListEntryNodeBuilder::create);
    private final DataNodeContainerModificationStrategy<ListSchemaNode> entryStrategy;
    private final UnkeyedListNode emptyNode;

    ListModificationStrategy(ListSchemaNode schema, DataTreeConfiguration treeConfig) {
        this.entryStrategy = new DataNodeContainerModificationStrategy<ListSchemaNode>(ITEM_SUPPORT, schema, treeConfig);
        this.emptyNode = ImmutableNodes.listNode((QName)schema.getQName());
    }

    @Override
    ListSchemaNode getSchema() {
        return (ListSchemaNode)this.entryStrategy.getSchema();
    }

    @Override
    Optional<? extends TreeNode> apply(ModifiedNode modification, Optional<? extends TreeNode> storeMeta, Version version) {
        return AutomaticLifecycleMixin.apply((x$0, x$1, x$2) -> super.apply(x$0, x$1, x$2), this::applyWrite, (NormalizedNode)this.emptyNode, modification, storeMeta, version);
    }

    @Override
    protected ChildTrackingPolicy getChildPolicy() {
        return ChildTrackingPolicy.ORDERED;
    }

    @Override
    protected TreeNode applyMerge(ModifiedNode modification, TreeNode currentMeta, Version version) {
        throw new IllegalStateException(String.format("Merge of modification %s on unkeyed list should never be called", modification));
    }

    @Override
    protected TreeNode applyTouch(ModifiedNode modification, TreeNode currentMeta, Version version) {
        throw new UnsupportedOperationException("UnkeyedList does not support subtree change.");
    }

    @Override
    protected TreeNode applyWrite(ModifiedNode modification, NormalizedNode newValue, Optional<? extends TreeNode> currentMeta, Version version) {
        TreeNode newValueMeta = TreeNode.of(newValue, version);
        if (modification.getChildren().isEmpty()) {
            return newValueMeta;
        }
        MutableTreeNode mutable = newValueMeta.mutable();
        mutable.setSubtreeVersion(version);
        return this.mutateChildren(mutable, (NormalizedNodeContainerBuilder)ImmutableUnkeyedListNodeBuilder.create((UnkeyedListNode)((UnkeyedListNode)newValue)), version, modification.getChildren());
    }

    private TreeNode mutateChildren(MutableTreeNode meta, NormalizedNodeContainerBuilder data, Version nodeVersion, Iterable<ModifiedNode> modifications) {
        for (ModifiedNode mod : modifications) {
            YangInstanceIdentifier.PathArgument id = mod.getIdentifier();
            Optional cm = meta.findChildByArg(id);
            Optional<? extends TreeNode> result = this.resolveChildOperation(id).apply(mod, cm, nodeVersion);
            if (result.isPresent()) {
                TreeNode tn = result.get();
                meta.putChild(tn);
                data.addChild(tn.getData());
                continue;
            }
            meta.removeChild(id);
            data.removeChild(id);
        }
        meta.setData(data.build());
        return meta.seal();
    }

    @Override
    public ModificationApplyOperation childByArg(YangInstanceIdentifier.PathArgument arg) {
        return arg instanceof YangInstanceIdentifier.NodeIdentifier ? this.entryStrategy : null;
    }

    @Override
    void verifyValue(NormalizedNode value) {
    }

    @Override
    void recursivelyVerifyStructure(NormalizedNode value) {
    }

    @Override
    protected void checkTouchApplicable(ModificationPath path, NodeModification modification, Optional<? extends TreeNode> current, Version version) throws IncorrectDataStructureException {
        throw new IncorrectDataStructureException(path.toInstanceIdentifier(), "Subtree modification is not allowed.");
    }

    @Override
    void mergeIntoModifiedNode(ModifiedNode node, NormalizedNode value, Version version) {
        node.write(value);
    }

    @Override
    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("entry", this.entryStrategy);
    }
}

