/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.api.TreeType;
import org.opendaylight.yangtools.yang.data.tree.impl.MandatoryDescendant;
import org.opendaylight.yangtools.yang.data.tree.impl.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraintAware;
import org.opendaylight.yangtools.yang.model.api.MandatoryAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MandatoryLeafEnforcer
implements Immutable {
    private static final Logger LOG = LoggerFactory.getLogger(MandatoryLeafEnforcer.class);
    private final ImmutableList<MandatoryDescendant> mandatoryNodes;

    private MandatoryLeafEnforcer(ImmutableList<MandatoryDescendant> mandatoryNodes) {
        this.mandatoryNodes = Objects.requireNonNull(mandatoryNodes);
    }

    static Optional<MandatoryLeafEnforcer> forContainer(DataNodeContainer schema, DataTreeConfiguration treeConfig) {
        if (!treeConfig.isMandatoryNodesValidationEnabled()) {
            return Optional.empty();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean isAugmentingNode = schema instanceof CopyableNode && ((CopyableNode)schema).isAugmenting();
        MandatoryLeafEnforcer.findMandatoryNodes((ImmutableList.Builder<MandatoryDescendant>)builder, YangInstanceIdentifier.empty(), schema, treeConfig.getTreeType(), isAugmentingNode);
        ImmutableList mandatoryNodes = builder.build();
        return mandatoryNodes.isEmpty() ? Optional.empty() : Optional.of(new MandatoryLeafEnforcer((ImmutableList<MandatoryDescendant>)mandatoryNodes));
    }

    void enforceOnData(NormalizedNode data) {
        this.mandatoryNodes.forEach(node -> node.enforceOnData(data));
    }

    void enforceOnTreeNode(TreeNode tree) {
        this.enforceOnData(tree.getData());
    }

    private static void findMandatoryNodes(ImmutableList.Builder<MandatoryDescendant> builder, YangInstanceIdentifier id, DataNodeContainer schema, TreeType type, boolean augmentedSubtree) {
        for (DataSchemaNode child : schema.getChildNodes()) {
            boolean needEnforce;
            if (!SchemaAwareApplyOperation.belongsToTree(type, child)) continue;
            if (child instanceof ContainerSchemaNode) {
                ContainerSchemaNode container = (ContainerSchemaNode)child;
                if (container.isPresenceContainer()) continue;
                if (!augmentedSubtree) {
                    boolean parentSchemaAugmenting;
                    boolean bl = parentSchemaAugmenting = schema instanceof CopyableNode && ((CopyableNode)schema).isAugmenting();
                    if (container.isAugmenting() && !parentSchemaAugmenting) {
                        AugmentationSchemaNode aug = MandatoryDescendant.getAugIdentifierOfChild(schema, child);
                        MandatoryLeafEnforcer.findMandatoryNodes(builder, id.node((YangInstanceIdentifier.PathArgument)DataSchemaContextNode.augmentationIdentifierFrom((AugmentationSchemaNode)aug)).node((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)container.getQName())), (DataNodeContainer)container, type, true);
                        continue;
                    }
                }
                MandatoryLeafEnforcer.findMandatoryNodes(builder, id.node((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)container.getQName())), (DataNodeContainer)container, type, augmentedSubtree);
                continue;
            }
            boolean bl = needEnforce = child instanceof MandatoryAware && ((MandatoryAware)child).isMandatory();
            if (!needEnforce && child instanceof ElementCountConstraintAware) {
                needEnforce = ((ElementCountConstraintAware)child).getElementCountConstraint().map(constraint -> {
                    Integer min = constraint.getMinElements();
                    return min != null && min > 0;
                }).orElse(Boolean.FALSE);
            }
            if (!needEnforce) continue;
            MandatoryDescendant desc = MandatoryDescendant.create(id, schema, child, augmentedSubtree);
            LOG.debug("Adding mandatory child {}", (Object)desc);
            builder.add((Object)desc);
        }
    }
}

