/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.SystemMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.UserMapNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableUserMapNodeBuilder;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.AutomaticLifecycleMixin;
import org.opendaylight.yangtools.yang.data.tree.impl.ChildTrackingPolicy;
import org.opendaylight.yangtools.yang.data.tree.impl.MapEntryModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.NormalizedNodeContainerSupport;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

final class MapModificationStrategy
extends AbstractNodeContainerModificationStrategy.Invisible<ListSchemaNode> {
    private static final NormalizedNodeContainerSupport<YangInstanceIdentifier.NodeIdentifier, UserMapNode> ORDERED_SUPPORT = new NormalizedNodeContainerSupport(UserMapNode.class, ChildTrackingPolicy.ORDERED, ImmutableUserMapNodeBuilder::create, ImmutableUserMapNodeBuilder::create);
    private static final NormalizedNodeContainerSupport<YangInstanceIdentifier.NodeIdentifier, SystemMapNode> UNORDERED_SUPPORT = new NormalizedNodeContainerSupport(SystemMapNode.class, ImmutableMapNodeBuilder::create, ImmutableMapNodeBuilder::create);
    private final @NonNull MapNode emptyNode;

    private MapModificationStrategy(NormalizedNodeContainerSupport<?, ?> support, ListSchemaNode schema, DataTreeConfiguration treeConfig, MapNode emptyNode) {
        super(support, treeConfig, MapEntryModificationStrategy.of(schema, treeConfig));
        this.emptyNode = Objects.requireNonNull(emptyNode);
    }

    static MapModificationStrategy of(ListSchemaNode schema, DataTreeConfiguration treeConfig) {
        UserMapNode emptyNode;
        NormalizedNodeContainerSupport<YangInstanceIdentifier.NodeIdentifier, UserMapNode> support;
        if (schema.isUserOrdered()) {
            support = ORDERED_SUPPORT;
            emptyNode = ImmutableNodes.orderedMapNode((QName)schema.getQName());
        } else {
            support = UNORDERED_SUPPORT;
            emptyNode = ImmutableNodes.mapNode((QName)schema.getQName());
        }
        return new MapModificationStrategy(support, schema, treeConfig, (MapNode)emptyNode);
    }

    @Override
    public ModificationApplyOperation childByArg(YangInstanceIdentifier.PathArgument arg) {
        return arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates ? this.entryStrategy() : null;
    }

    @Override
    Optional<? extends TreeNode> apply(ModifiedNode modification, Optional<? extends TreeNode> storeMeta, Version version) {
        return AutomaticLifecycleMixin.apply((x$0, x$1, x$2) -> super.apply(x$0, x$1, x$2), this::applyWrite, (NormalizedNode)this.emptyNode, modification, storeMeta, version);
    }

    @Override
    TreeNode defaultTreeNode() {
        return MapModificationStrategy.defaultTreeNode((NormalizedNode)this.emptyNode);
    }
}

