/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.IncorrectDataStructureException;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.impl.ChildTrackingPolicy;
import org.opendaylight.yangtools.yang.data.tree.impl.LogicalOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationPath;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.NodeModification;
import org.opendaylight.yangtools.yang.data.tree.impl.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

final class ValueNodeModificationStrategy<T extends DataSchemaNode, V extends NormalizedNode>
extends SchemaAwareApplyOperation<T> {
    private final @NonNull Class<V> nodeClass;
    private final @NonNull T schema;

    ValueNodeModificationStrategy(Class<V> nodeClass, T schema) {
        this.nodeClass = Objects.requireNonNull(nodeClass);
        this.schema = (DataSchemaNode)Objects.requireNonNull(schema);
    }

    @Override
    T getSchema() {
        return this.schema;
    }

    @Override
    public ModificationApplyOperation childByArg(YangInstanceIdentifier.PathArgument arg) {
        throw new UnsupportedOperationException("Node " + this.schema + " is leaf type node. Child nodes not allowed");
    }

    @Override
    protected ChildTrackingPolicy getChildPolicy() {
        return ChildTrackingPolicy.NONE;
    }

    @Override
    protected TreeNode applyTouch(ModifiedNode modification, TreeNode currentMeta, Version version) {
        throw new UnsupportedOperationException("Node " + this.schema + " is leaf type node.  Subtree change is not allowed.");
    }

    @Override
    protected TreeNode applyMerge(ModifiedNode modification, TreeNode currentMeta, Version version) {
        NormalizedNode newValue = modification.getWrittenValue();
        this.verifyWrittenValue(newValue);
        modification.resolveModificationType(ModificationType.WRITE);
        return this.applyWrite(modification, newValue, null, version);
    }

    @Override
    protected TreeNode applyWrite(ModifiedNode modification, NormalizedNode newValue, Optional<? extends TreeNode> currentMeta, Version version) {
        return TreeNode.of(newValue, version);
    }

    @Override
    protected void checkTouchApplicable(ModificationPath path, NodeModification modification, Optional<? extends TreeNode> current, Version version) throws IncorrectDataStructureException {
        throw new IncorrectDataStructureException(path.toInstanceIdentifier(), "Subtree modification is not allowed.");
    }

    @Override
    void mergeIntoModifiedNode(ModifiedNode node, NormalizedNode value, Version version) {
        switch (node.getOperation()) {
            case DELETE: 
            case WRITE: {
                node.write(value);
                break;
            }
            default: {
                node.updateValue(LogicalOperation.MERGE, value);
            }
        }
    }

    @Override
    void verifyValue(NormalizedNode writtenValue) {
        this.verifyWrittenValue(writtenValue);
    }

    @Override
    void recursivelyVerifyStructure(NormalizedNode value) {
        this.verifyWrittenValue(value);
    }

    @Override
    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("value", (Object)this.nodeClass.getSimpleName());
    }

    private void verifyWrittenValue(NormalizedNode value) {
        Preconditions.checkArgument((boolean)this.nodeClass.isInstance(value), (String)"Expected an instance of %s, have %s", this.nodeClass, (Object)value);
    }
}

