/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.leafref;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefPath;
import org.opendaylight.yangtools.yang.data.tree.leafref.QNamePredicateBuilder;
import org.opendaylight.yangtools.yang.data.tree.leafref.QNameWithPredicate;
import org.opendaylight.yangtools.yang.data.tree.leafref.QNameWithPredicateBuilder;
import org.opendaylight.yangtools.yang.data.tree.leafref.SimpleQNameWithPredicate;
import org.opendaylight.yangtools.yang.model.api.PathExpression;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.xpath.api.YangBinaryExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangBinaryOperator;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangFunction;
import org.opendaylight.yangtools.yang.xpath.api.YangFunctionCallExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangLocationPath;
import org.opendaylight.yangtools.yang.xpath.api.YangPathExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangQNameExpr;

final class LeafRefPathParserImpl {
    private final QNameModule leafrefModule;
    private final QNameModule nodeModule;

    LeafRefPathParserImpl(LeafrefTypeDefinition leafrefType, TypedDataSchemaNode currentNode) {
        this.leafrefModule = LeafRefPathParserImpl.getBaseModule(leafrefType);
        this.nodeModule = currentNode.getQName().getModule();
    }

    LeafRefPath parseLeafRefPath(PathExpression path) {
        PathExpression.Steps steps = path.getSteps();
        if (steps instanceof PathExpression.LocationPathSteps) {
            return this.parseLocationPath(((PathExpression.LocationPathSteps)steps).getLocationPath());
        }
        if (steps instanceof PathExpression.DerefSteps) {
            throw new UnsupportedOperationException("deref() leafrefs are not implemented yet");
        }
        throw new IllegalStateException("Unsupported steps " + steps);
    }

    private LeafRefPath parseLocationPath(YangLocationPath locationPath) {
        return LeafRefPath.create(LeafRefPathParserImpl.createPathSteps(locationPath.isAbsolute() ? this.leafrefModule : this.nodeModule, (ImmutableList<YangLocationPath.Step>)locationPath.getSteps()), locationPath.isAbsolute());
    }

    private static Deque<QNameWithPredicate> createPathSteps(QNameModule localModule, ImmutableList<YangLocationPath.Step> steps) {
        ArrayDeque<QNameWithPredicate> path = new ArrayDeque<QNameWithPredicate>(steps.size());
        block4: for (YangLocationPath.Step step : steps) {
            switch (step.getAxis()) {
                case CHILD: {
                    Preconditions.checkState((boolean)(step instanceof YangLocationPath.QNameStep), (String)"Unsupported step %s", (Object)step);
                    path.add(LeafRefPathParserImpl.adaptChildStep((YangLocationPath.QNameStep)step, localModule));
                    continue block4;
                }
                case PARENT: {
                    path.add(QNameWithPredicate.UP_PARENT);
                    continue block4;
                }
            }
            throw new IllegalStateException("Unsupported axis in step " + step);
        }
        return path;
    }

    private static QNameWithPredicate adaptChildStep(YangLocationPath.QNameStep step, QNameModule localModule) {
        QName qname = LeafRefPathParserImpl.resolve(step.getQName(), localModule);
        Set predicates = step.getPredicates();
        if (predicates.isEmpty()) {
            return new SimpleQNameWithPredicate(qname);
        }
        QNameWithPredicateBuilder builder = new QNameWithPredicateBuilder(qname.getModule(), qname.getLocalName());
        for (YangExpr pred : predicates) {
            QNamePredicateBuilder predBuilder = new QNamePredicateBuilder();
            if (pred instanceof YangBinaryExpr) {
                YangBinaryExpr eqPred = (YangBinaryExpr)pred;
                Preconditions.checkState((eqPred.getOperator() == YangBinaryOperator.EQUALS ? 1 : 0) != 0);
                YangExpr left = eqPred.getLeftExpr();
                Preconditions.checkState((boolean)(left instanceof YangQNameExpr), (String)"Unsupported left expression %s", (Object)left);
                predBuilder.setIdentifier(LeafRefPathParserImpl.resolve(((YangQNameExpr)left).getQName(), localModule));
                YangExpr right = eqPred.getRightExpr();
                if (right instanceof YangPathExpr) {
                    YangPathExpr rightPath = (YangPathExpr)right;
                    YangExpr filter = rightPath.getFilterExpr();
                    if (!(filter instanceof YangFunctionCallExpr)) {
                        throw new IllegalStateException("Unhandled filter " + filter);
                    }
                    Preconditions.checkState((boolean)YangFunction.CURRENT.getIdentifier().equals((Object)((YangFunctionCallExpr)filter).getName()));
                    YangLocationPath.Relative location = (YangLocationPath.Relative)rightPath.getLocationPath().orElseThrow(() -> new IllegalStateException("Missing locationPath in " + rightPath));
                    predBuilder.setPathKeyExpression(LeafRefPath.create(LeafRefPathParserImpl.createPathSteps(localModule, (ImmutableList<YangLocationPath.Step>)location.getSteps()), false));
                } else {
                    throw new UnsupportedOperationException("Not implemented for " + right);
                }
            }
            builder.addQNamePredicate(predBuilder.build());
        }
        return builder.build();
    }

    private static QName resolve(AbstractQName qname, QNameModule localModule) {
        if (qname instanceof QName) {
            return (QName)qname;
        }
        if (qname instanceof UnresolvedQName.Unqualified) {
            return ((UnresolvedQName.Unqualified)qname).bindTo(localModule).intern();
        }
        throw new IllegalStateException("Unhandled unresolved QName " + qname);
    }

    private static QNameModule getBaseModule(LeafrefTypeDefinition leafrefType) {
        LeafrefTypeDefinition current = leafrefType;
        LeafrefTypeDefinition base;
        while ((base = (LeafrefTypeDefinition)current.getBaseType()) != null) {
            current = base;
        }
        return current.getQName().getModule();
    }
}

