/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.leafref;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.tree.leafref.QNamePredicate;
import org.opendaylight.yangtools.yang.data.tree.leafref.QNameWithPredicate;
import org.opendaylight.yangtools.yang.data.tree.leafref.QNameWithPredicateImpl;
import org.opendaylight.yangtools.yang.data.tree.leafref.SimpleQNameWithPredicate;

class QNameWithPredicateBuilder
implements Mutable {
    private final List<QNamePredicate> qnamePredicates = new ArrayList<QNamePredicate>();
    private QNameModule moduleQname;
    private String localName;
    static final QNameWithPredicateBuilder UP_PARENT_BUILDER = new QNameWithPredicateBuilder(null, ".."){

        @Override
        public QNameWithPredicate build() {
            return QNameWithPredicate.UP_PARENT;
        }
    };

    QNameWithPredicateBuilder(QNameModule moduleQname, String localName) {
        this.moduleQname = moduleQname;
        this.localName = localName;
    }

    public @NonNull QNameWithPredicate build() {
        if (this.qnamePredicates.isEmpty() && this.moduleQname != null && this.localName != null) {
            return new SimpleQNameWithPredicate(QName.create((QNameModule)this.moduleQname, (String)this.localName));
        }
        QNameWithPredicateImpl qNameWithPredicateImpl = new QNameWithPredicateImpl(this.moduleQname, this.localName, this.qnamePredicates);
        this.qnamePredicates.clear();
        return qNameWithPredicateImpl;
    }

    public List<QNamePredicate> getQNamePredicates() {
        return this.qnamePredicates;
    }

    public void addQNamePredicate(QNamePredicate qnamePredicate) {
        this.qnamePredicates.add(qnamePredicate);
    }

    public QNameModule getModuleQname() {
        return this.moduleQname;
    }

    public void setModuleQname(QNameModule moduleQname) {
        this.moduleQname = moduleQname;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QNameWithPredicateBuilder)) {
            return false;
        }
        QNameWithPredicateBuilder other = (QNameWithPredicateBuilder)obj;
        return Objects.equals(this.localName, other.localName) && this.moduleQname.equals((Object)other.moduleQname);
    }

    public int hashCode() {
        int result = this.moduleQname != null ? this.moduleQname.hashCode() : 0;
        result = 31 * result + Objects.hashCode(this.localName);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.moduleQname != null) {
            sb.append('(').append(this.moduleQname.getNamespace());
            sb.append("?revision=").append(this.moduleQname.getRevision());
            sb.append(')');
        }
        sb.append(this.localName);
        for (QNamePredicate predicate : this.qnamePredicates) {
            sb.append(predicate);
        }
        return sb.toString();
    }
}

