/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.Verify;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.impl.LogicalOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;

final class AutomaticLifecycleMixin {
    private AutomaticLifecycleMixin() {
    }

    static @Nullable TreeNode apply(Apply delegate, ApplyWrite writeDelegate, NormalizedNode emptyNode, ModifiedNode modification, @Nullable TreeNode currentMeta, Version version) {
        TreeNode ret;
        if (modification.getOperation() == LogicalOperation.DELETE) {
            if (modification.isEmpty()) {
                return delegate.apply(modification, currentMeta, version);
            }
            ret = (TreeNode)Verify.verifyNotNull((Object)writeDelegate.applyWrite(modification, emptyNode, currentMeta, version));
        } else {
            ret = modification.getOperation() == LogicalOperation.TOUCH && currentMeta == null ? AutomaticLifecycleMixin.applyTouch(delegate, emptyNode, modification, null, version) : delegate.apply(modification, currentMeta, version);
        }
        return ret == null ? null : AutomaticLifecycleMixin.disappearResult(modification, ret, currentMeta);
    }

    private static @Nullable TreeNode applyTouch(Apply delegate, NormalizedNode emptyNode, ModifiedNode modification, @Nullable TreeNode currentMeta, Version version) {
        TreeNode ret = delegate.apply(modification, AutomaticLifecycleMixin.fakeMeta(emptyNode, version), version);
        if (modification.getModificationType() == ModificationType.SUBTREE_MODIFIED) {
            modification.resolveModificationType(ModificationType.APPEARED);
        }
        return ret;
    }

    private static @Nullable TreeNode disappearResult(ModifiedNode modification, @NonNull TreeNode result, @Nullable TreeNode currentMeta) {
        NormalizedNode data = result.getData();
        if (!(data instanceof NormalizedNodeContainer)) {
            throw new IllegalStateException("Unhandled data " + data);
        }
        NormalizedNodeContainer container = (NormalizedNodeContainer)data;
        if (!container.isEmpty()) {
            return result;
        }
        ModificationType finalType = currentMeta == null ? ModificationType.UNMODIFIED : (modification.getModificationType() == ModificationType.WRITE ? ModificationType.DELETE : ModificationType.DISAPPEARED);
        modification.resolveModificationType(finalType);
        return null;
    }

    private static @NonNull TreeNode fakeMeta(NormalizedNode emptyNode, Version version) {
        return TreeNode.of(emptyNode, version);
    }

    @FunctionalInterface
    static interface Apply {
        public @Nullable TreeNode apply(ModifiedNode var1, @Nullable TreeNode var2, Version var3);
    }

    @FunctionalInterface
    static interface ApplyWrite {
        public TreeNode applyWrite(ModifiedNode var1, NormalizedNode var2, @Nullable TreeNode var3, Version var4);
    }
}

