/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.spi.node.MandatoryLeafEnforcer;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.api.TreeType;
import org.opendaylight.yangtools.yang.data.tree.impl.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

class CaseEnforcer
implements Immutable {
    private final ImmutableMap<YangInstanceIdentifier.NodeIdentifier, DataSchemaNode> children;

    CaseEnforcer(ImmutableMap<YangInstanceIdentifier.NodeIdentifier, DataSchemaNode> children) {
        this.children = Objects.requireNonNull(children);
    }

    static CaseEnforcer forTree(CaseSchemaNode schema, DataTreeConfiguration treeConfig) {
        MandatoryLeafEnforcer enforcer;
        ImmutableMap children;
        TreeType treeType = treeConfig.getTreeType();
        ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
        if (SchemaAwareApplyOperation.belongsToTree(treeType, (DataSchemaNode)schema)) {
            for (DataSchemaNode child : schema.getChildNodes()) {
                if (!SchemaAwareApplyOperation.belongsToTree(treeType, child)) continue;
                childrenBuilder.put((Object)YangInstanceIdentifier.NodeIdentifier.create((QName)child.getQName()), (Object)child);
            }
        }
        if ((children = childrenBuilder.build()).isEmpty()) {
            return null;
        }
        if (treeConfig.isMandatoryNodesValidationEnabled() && (enforcer = MandatoryLeafEnforcer.forContainer((DataNodeContainer)schema, (treeType == TreeType.OPERATIONAL ? 1 : 0) != 0)) != null) {
            return new EnforcingMandatory((ImmutableMap<YangInstanceIdentifier.NodeIdentifier, DataSchemaNode>)children, enforcer);
        }
        return new CaseEnforcer((ImmutableMap<YangInstanceIdentifier.NodeIdentifier, DataSchemaNode>)children);
    }

    final Set<Map.Entry<YangInstanceIdentifier.NodeIdentifier, DataSchemaNode>> getChildEntries() {
        return this.children.entrySet();
    }

    final Set<YangInstanceIdentifier.NodeIdentifier> getChildIdentifiers() {
        return this.children.keySet();
    }

    void enforceOnChoice(ChoiceNode choice) {
    }

    private static final class EnforcingMandatory
    extends CaseEnforcer {
        private final MandatoryLeafEnforcer enforcer;

        EnforcingMandatory(ImmutableMap<YangInstanceIdentifier.NodeIdentifier, DataSchemaNode> children, MandatoryLeafEnforcer enforcer) {
            super(children);
            this.enforcer = Objects.requireNonNull(enforcer);
        }

        @Override
        void enforceOnChoice(ChoiceNode choice) {
            this.enforcer.enforceOnData((NormalizedNode)choice);
        }
    }
}

