/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.AutomaticLifecycleMixin;
import org.opendaylight.yangtools.yang.data.tree.impl.CaseEnforcer;
import org.opendaylight.yangtools.yang.data.tree.impl.ExcludedDataSchemaNodeException;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.NormalizedNodeContainerSupport;
import org.opendaylight.yangtools.yang.data.tree.impl.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

final class ChoiceModificationStrategy
extends AbstractNodeContainerModificationStrategy.Visible<ChoiceSchemaNode> {
    private static final NormalizedNodeContainerSupport<YangInstanceIdentifier.NodeIdentifier, ChoiceNode> SUPPORT = new NormalizedNodeContainerSupport(ChoiceNode.class, arg_0 -> ((NormalizedNode.BuilderFactory)BUILDER_FACTORY).newChoiceBuilder(arg_0), () -> ((NormalizedNode.BuilderFactory)BUILDER_FACTORY).newChoiceBuilder());
    private final ImmutableMap<YangInstanceIdentifier.PathArgument, ModificationApplyOperation> childNodes;
    private final ImmutableMap<CaseEnforcer, ImmutableList<CaseEnforcer>> exclusions;
    private final ImmutableMap<YangInstanceIdentifier.PathArgument, CaseEnforcer> caseEnforcers;
    private final @NonNull ChoiceNode emptyNode;

    ChoiceModificationStrategy(ChoiceSchemaNode schema, DataTreeConfiguration treeConfig) {
        super(SUPPORT, treeConfig, schema);
        ImmutableMap.Builder childBuilder = ImmutableMap.builder();
        ImmutableMap.Builder enforcerBuilder = ImmutableMap.builder();
        for (CaseSchemaNode caze : schema.getCases()) {
            CaseEnforcer enforcer2 = CaseEnforcer.forTree(caze, treeConfig);
            if (enforcer2 == null) continue;
            for (Map.Entry<YangInstanceIdentifier.NodeIdentifier, DataSchemaNode> entry : enforcer2.getChildEntries()) {
                ModificationApplyOperation childOper;
                try {
                    childOper = SchemaAwareApplyOperation.from(entry.getValue(), treeConfig);
                }
                catch (ExcludedDataSchemaNodeException e) {
                    throw new IllegalStateException("Enforcer references out-of-tree child " + entry, e);
                }
                childBuilder.put((Object)((YangInstanceIdentifier.PathArgument)entry.getKey()), (Object)childOper);
                enforcerBuilder.put((Object)((YangInstanceIdentifier.PathArgument)entry.getKey()), (Object)enforcer2);
            }
        }
        this.childNodes = childBuilder.build();
        this.caseEnforcers = enforcerBuilder.build();
        HashMap<CaseEnforcer, ImmutableList> exclusionsBuilder = new HashMap<CaseEnforcer, ImmutableList>();
        for (CaseEnforcer key : this.caseEnforcers.values()) {
            exclusionsBuilder.put(key, (ImmutableList)this.caseEnforcers.values().stream().filter(enforcer -> !key.equals(enforcer)).collect(ImmutableList.toImmutableList()));
        }
        this.exclusions = ImmutableMap.copyOf(exclusionsBuilder);
        this.emptyNode = (ChoiceNode)BUILDER_FACTORY.newChoiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName())).build();
    }

    @Override
    TreeNode apply(ModifiedNode modification, TreeNode currentMeta, Version version) {
        return AutomaticLifecycleMixin.apply((x$0, x$1, x$2) -> super.apply(x$0, x$1, x$2), this::applyWrite, (NormalizedNode)this.emptyNode, modification, currentMeta, version);
    }

    @Override
    TreeNode defaultTreeNode() {
        return ChoiceModificationStrategy.defaultTreeNode((NormalizedNode)this.emptyNode);
    }

    @Override
    public ModificationApplyOperation childByArg(YangInstanceIdentifier.PathArgument arg) {
        return (ModificationApplyOperation)this.childNodes.get((Object)arg);
    }

    @Override
    void optionalVerifyValueChildren(DistinctNodeContainer<?, ?> writtenValue) {
        this.enforceCases((NormalizedNode)writtenValue);
    }

    private void enforceCases(TreeNode tree) {
        this.enforceCases(tree.getData());
    }

    private void enforceCases(NormalizedNode normalizedNode) {
        Verify.verify((boolean)(normalizedNode instanceof ChoiceNode));
        ChoiceNode choice = (ChoiceNode)normalizedNode;
        if (!choice.isEmpty()) {
            DataContainerChild firstChild = (DataContainerChild)choice.body().iterator().next();
            CaseEnforcer enforcer = (CaseEnforcer)Verify.verifyNotNull((Object)((CaseEnforcer)this.caseEnforcers.get((Object)firstChild.name())), (String)"Case enforcer cannot be null. Most probably, child node %s of choice node %s does not belong in current tree type.", (Object[])new Object[]{firstChild.name(), normalizedNode.name()});
            for (CaseEnforcer other : (ImmutableList)Verify.verifyNotNull((Object)((ImmutableList)this.exclusions.get((Object)enforcer)))) {
                for (YangInstanceIdentifier.NodeIdentifier id : other.getChildIdentifiers()) {
                    DataContainerChild child = (DataContainerChild)choice.childByArg((YangInstanceIdentifier.PathArgument)id);
                    Preconditions.checkArgument((child == null ? 1 : 0) != 0, (String)"Child %s (from case %s) implies non-presence of child %s (from case %s), which is %s", (Object[])new Object[]{firstChild.name(), enforcer, id, other, child});
                }
            }
            enforcer.enforceOnChoice(choice);
        }
    }

    @Override
    protected TreeNode applyMerge(ModifiedNode modification, TreeNode currentMeta, Version version) {
        TreeNode ret = super.applyMerge(modification, currentMeta, version);
        this.enforceCases(ret);
        return ret;
    }

    @Override
    protected TreeNode applyWrite(ModifiedNode modification, NormalizedNode newValue, TreeNode currentMeta, Version version) {
        TreeNode ret = super.applyWrite(modification, newValue, currentMeta, version);
        this.enforceCases(ret);
        return ret;
    }

    @Override
    protected TreeNode applyTouch(ModifiedNode modification, TreeNode currentMeta, Version version) {
        TreeNode ret = super.applyTouch(modification, currentMeta, version);
        this.enforceCases(ret);
        return ret;
    }
}

