/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.tree.api.CursorAwareDataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeSnapshotCursor;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractCursorAware;
import org.opendaylight.yangtools.yang.data.tree.impl.InMemoryDataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.impl.InMemoryDataTreeSnapshotCursor;
import org.opendaylight.yangtools.yang.data.tree.impl.RootApplyStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

final class InMemoryDataTreeSnapshot
extends AbstractCursorAware
implements CursorAwareDataTreeSnapshot {
    private final @NonNull EffectiveModelContext modelContext;
    private final @NonNull RootApplyStrategy applyOper;
    private final @NonNull TreeNode rootNode;

    InMemoryDataTreeSnapshot(EffectiveModelContext modelContext, TreeNode rootNode, RootApplyStrategy applyOper) {
        this.modelContext = Objects.requireNonNull(modelContext);
        this.rootNode = Objects.requireNonNull(rootNode);
        this.applyOper = Objects.requireNonNull(applyOper);
    }

    @NonNull TreeNode getRootNode() {
        return this.rootNode;
    }

    public EffectiveModelContext modelContext() {
        return this.modelContext;
    }

    public Optional<NormalizedNode> readNode(YangInstanceIdentifier path) {
        return NormalizedNodes.findNode((NormalizedNode)this.rootNode.getData(), (YangInstanceIdentifier)path);
    }

    public InMemoryDataTreeModification newModification() {
        return new InMemoryDataTreeModification(this, this.applyOper);
    }

    public Optional<DataTreeSnapshotCursor> openCursor(YangInstanceIdentifier path) {
        return NormalizedNodes.findNode((NormalizedNode)this.rootNode.getData(), (YangInstanceIdentifier)path).map(root -> {
            Preconditions.checkArgument((boolean)(root instanceof DistinctNodeContainer), (String)"Child %s is not a container", (Object)path);
            return this.openCursor(new InMemoryDataTreeSnapshotCursor(this, path, (DistinctNodeContainer)root));
        });
    }

    public String toString() {
        return this.rootNode.getSubtreeVersion().toString();
    }
}

