/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.SystemMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.UserMapNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.AutomaticLifecycleMixin;
import org.opendaylight.yangtools.yang.data.tree.impl.ChildTrackingPolicy;
import org.opendaylight.yangtools.yang.data.tree.impl.MapEntryModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.NormalizedNodeContainerSupport;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

final class MapModificationStrategy
extends AbstractNodeContainerModificationStrategy.Invisible<ListSchemaNode> {
    private static final NormalizedNodeContainerSupport<YangInstanceIdentifier.NodeIdentifier, UserMapNode> ORDERED_SUPPORT = new NormalizedNodeContainerSupport(UserMapNode.class, ChildTrackingPolicy.ORDERED, arg_0 -> ((NormalizedNode.BuilderFactory)BUILDER_FACTORY).newUserMapBuilder(arg_0), () -> ((NormalizedNode.BuilderFactory)BUILDER_FACTORY).newUserMapBuilder());
    private static final NormalizedNodeContainerSupport<YangInstanceIdentifier.NodeIdentifier, SystemMapNode> UNORDERED_SUPPORT = new NormalizedNodeContainerSupport(SystemMapNode.class, arg_0 -> ((NormalizedNode.BuilderFactory)BUILDER_FACTORY).newSystemMapBuilder(arg_0), () -> ((NormalizedNode.BuilderFactory)BUILDER_FACTORY).newSystemMapBuilder());
    private final @NonNull MapNode emptyNode;

    private MapModificationStrategy(NormalizedNodeContainerSupport<?, ?> support, ListSchemaNode schema, DataTreeConfiguration treeConfig, MapNode emptyNode) {
        super(support, treeConfig, MapEntryModificationStrategy.of(schema, treeConfig));
        this.emptyNode = Objects.requireNonNull(emptyNode);
    }

    static MapModificationStrategy of(ListSchemaNode schema, DataTreeConfiguration treeConfig) {
        MapNode emptyNode;
        NormalizedNodeContainerSupport<YangInstanceIdentifier.NodeIdentifier, UserMapNode> support;
        YangInstanceIdentifier.NodeIdentifier name = YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName());
        if (schema.isUserOrdered()) {
            support = ORDERED_SUPPORT;
            emptyNode = (MapNode)BUILDER_FACTORY.newUserMapBuilder().withNodeIdentifier(name).build();
        } else {
            support = UNORDERED_SUPPORT;
            emptyNode = (MapNode)BUILDER_FACTORY.newSystemMapBuilder().withNodeIdentifier(name).build();
        }
        return new MapModificationStrategy(support, schema, treeConfig, emptyNode);
    }

    @Override
    public ModificationApplyOperation childByArg(YangInstanceIdentifier.PathArgument arg) {
        return arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates ? this.entryStrategy() : null;
    }

    @Override
    TreeNode apply(ModifiedNode modification, TreeNode currentMeta, Version version) {
        return AutomaticLifecycleMixin.apply((x$0, x$1, x$2) -> super.apply(x$0, x$1, x$2), this::applyWrite, (NormalizedNode)this.emptyNode, modification, currentMeta, version);
    }

    @Override
    TreeNode defaultTreeNode() {
        return MapModificationStrategy.defaultTreeNode((NormalizedNode)this.emptyNode);
    }
}

