/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractDataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.impl.LogicalOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;

final class NoopDataTreeCandidate
extends AbstractDataTreeCandidate {
    private static final DataTreeCandidateNode ROOT = new DataTreeCandidateNode(){

        public ModificationType modificationType() {
            return ModificationType.UNMODIFIED;
        }

        public Collection<DataTreeCandidateNode> childNodes() {
            return List.of();
        }

        public YangInstanceIdentifier.PathArgument name() {
            throw new IllegalStateException("Attempted to read identifier of the no-operation change");
        }

        public NormalizedNode dataAfter() {
            return null;
        }

        public NormalizedNode dataBefore() {
            return null;
        }

        public DataTreeCandidateNode modifiedChild(YangInstanceIdentifier.PathArgument identifier) {
            return null;
        }
    };
    private final @NonNull TreeNode afterRoot;

    protected NoopDataTreeCandidate(YangInstanceIdentifier rootPath, ModifiedNode modificationRoot, TreeNode afterRoot) {
        super(rootPath);
        Preconditions.checkArgument((modificationRoot.getOperation() == LogicalOperation.NONE ? 1 : 0) != 0);
        this.afterRoot = Objects.requireNonNull(afterRoot);
    }

    public DataTreeCandidateNode getRootNode() {
        return ROOT;
    }

    @Override
    protected TreeNode getTipRoot() {
        return this.afterRoot;
    }
}

